/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime.matcher;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.matcher.PipeDataRegionMatcher;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSchemaPatternMatcher
implements PipeDataRegionMatcher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CachedSchemaPatternMatcher.class);
    protected static final String TREE_MODEL_EVENT_TABLE_NAME_PREFIX = "root.";
    protected final ReentrantReadWriteLock lock;
    private final AccessControl accessControl = Coordinator.getInstance().getAccessControl();
    protected final Set<PipeRealtimeDataRegionSource> sources;
    protected final Cache<IDeviceID, Set<PipeRealtimeDataRegionSource>> deviceToSourcesCache;
    protected final Cache<Pair<String, IDeviceID>, Set<PipeRealtimeDataRegionSource>> databaseAndTableToSourcesCache;

    public CachedSchemaPatternMatcher() {
        this.lock = new ReentrantReadWriteLock();
        this.sources = new CopyOnWriteArraySet<PipeRealtimeDataRegionSource>();
        this.deviceToSourcesCache = Caffeine.newBuilder().maximumSize(PipeConfig.getInstance().getPipeSourceMatcherCacheSize()).build();
        this.databaseAndTableToSourcesCache = Caffeine.newBuilder().maximumSize(PipeConfig.getInstance().getPipeSourceMatcherCacheSize()).build();
    }

    @Override
    public void register(PipeRealtimeDataRegionSource source) {
        this.lock.writeLock().lock();
        try {
            this.sources.add(source);
            this.deviceToSourcesCache.invalidateAll();
            this.databaseAndTableToSourcesCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deregister(PipeRealtimeDataRegionSource source) {
        this.lock.writeLock().lock();
        try {
            this.sources.remove(source);
            this.deviceToSourcesCache.invalidateAll();
            this.databaseAndTableToSourcesCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void invalidateCache() {
        this.lock.writeLock().lock();
        try {
            this.databaseAndTableToSourcesCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getRegisterCount() {
        this.lock.readLock().lock();
        try {
            int n = this.sources.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Set<PipeRealtimeDataRegionSource>, Set<PipeRealtimeDataRegionSource>> match(PipeRealtimeEvent event) {
        HashSet<PipeRealtimeDataRegionSource> matchedSources = new HashSet<PipeRealtimeDataRegionSource>();
        this.lock.readLock().lock();
        try {
            if (this.sources.isEmpty()) {
                Pair pair = new Pair(matchedSources, this.sources);
                return pair;
            }
            if (event.getEvent() instanceof PipeHeartbeatEvent) {
                Pair pair = new Pair(this.sources, (Object)Collections.EMPTY_SET);
                return pair;
            }
            if (event.getEvent() instanceof PipeDeleteDataNodeEvent) {
                this.sources.stream().filter(PipeRealtimeDataRegionSource::shouldExtractDeletion).forEach(matchedSources::add);
                Pair pair = new Pair(matchedSources, this.findUnmatchedSources(matchedSources));
                return pair;
            }
            for (Map.Entry<IDeviceID, String[]> entry : event.getSchemaInfo().entrySet()) {
                IDeviceID deviceID = entry.getKey();
                if (deviceID instanceof PlainDeviceID || deviceID.getTableName().startsWith(TREE_MODEL_EVENT_TABLE_NAME_PREFIX) || deviceID.getTableName().equals("root")) {
                    event.markAsTreeModelEvent();
                    this.matchTreeModelEvent(deviceID, entry.getValue(), matchedSources);
                } else {
                    event.markAsTableModelEvent();
                    this.matchTableModelEvent(event.getEvent() instanceof PipeInsertionEvent ? ((PipeInsertionEvent)event.getEvent()).getTableModelDatabaseName() : null, deviceID, matchedSources);
                }
                if (matchedSources.size() != this.sources.size()) continue;
                break;
            }
            Pair pair = new Pair(matchedSources, this.findUnmatchedSources(matchedSources));
            return pair;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Set<PipeRealtimeDataRegionSource> findUnmatchedSources(Set<PipeRealtimeDataRegionSource> matchedSources) {
        HashSet<PipeRealtimeDataRegionSource> unmatchedSources = new HashSet<PipeRealtimeDataRegionSource>();
        for (PipeRealtimeDataRegionSource source : this.sources) {
            if (matchedSources.contains(source)) continue;
            unmatchedSources.add(source);
        }
        return unmatchedSources;
    }

    protected void matchTreeModelEvent(IDeviceID device, String[] measurements, Set<PipeRealtimeDataRegionSource> matchedSources) {
        Set sourcesFilteredByDevice = (Set)this.deviceToSourcesCache.get((Object)device, this::filterSourcesByDevice);
        if (sourcesFilteredByDevice == null) {
            LOGGER.warn("Sources filtered by device is null when matching sources for tree model event.", (Throwable)new Exception());
            return;
        }
        if (measurements.length == 0) {
            matchedSources.addAll(sourcesFilteredByDevice);
        } else {
            sourcesFilteredByDevice.forEach(source -> {
                if (matchedSources.size() == this.sources.size()) {
                    return;
                }
                TreePattern pattern = source.getTreePattern();
                if (Objects.isNull(pattern) || pattern.isRoot() || pattern.coversDevice(device)) {
                    matchedSources.add((PipeRealtimeDataRegionSource)source);
                } else {
                    for (String measurement : measurements) {
                        if (measurement == null || !pattern.matchesMeasurement(device, measurement)) continue;
                        matchedSources.add((PipeRealtimeDataRegionSource)source);
                        break;
                    }
                }
            });
        }
    }

    protected Set<PipeRealtimeDataRegionSource> filterSourcesByDevice(IDeviceID device) {
        HashSet<PipeRealtimeDataRegionSource> filteredSources = new HashSet<PipeRealtimeDataRegionSource>();
        for (PipeRealtimeDataRegionSource source : this.sources) {
            TreePattern treePattern;
            if (!source.shouldExtractInsertion() || !Objects.isNull(treePattern = source.getTreePattern()) && (!treePattern.isTreeModelDataAllowedToBeCaptured() || !treePattern.mayOverlapWithDevice(device))) continue;
            filteredSources.add(source);
        }
        return filteredSources;
    }

    protected void matchTableModelEvent(String databaseName, IDeviceID tableName, Set<PipeRealtimeDataRegionSource> matchedSources) {
        if (databaseName == null) {
            LOGGER.warn("Database name is null when matching sources for table model event.", (Throwable)new Exception());
            return;
        }
        Set sourcesFilteredByDatabaseAndTable = (Set)this.databaseAndTableToSourcesCache.get((Object)new Pair((Object)databaseName, (Object)tableName), this::filterSourcesByDatabaseAndTable);
        if (sourcesFilteredByDatabaseAndTable == null) {
            LOGGER.warn("Sources filtered by database and table is null when matching sources for table model event.", (Throwable)new Exception());
            return;
        }
        matchedSources.addAll(sourcesFilteredByDatabaseAndTable);
    }

    protected Set<PipeRealtimeDataRegionSource> filterSourcesByDatabaseAndTable(Pair<String, IDeviceID> databaseNameAndTableName) {
        HashSet<PipeRealtimeDataRegionSource> filteredSources = new HashSet<PipeRealtimeDataRegionSource>();
        for (PipeRealtimeDataRegionSource source : this.sources) {
            TablePattern tablePattern;
            if (!source.shouldExtractInsertion() || !this.matchesTablePattern(tablePattern = source.getTablePattern(), databaseNameAndTableName) || source.isSkipIfNoPrivileges() && !this.notFilteredByAccess(source.getUserName(), databaseNameAndTableName)) continue;
            filteredSources.add(source);
        }
        return filteredSources;
    }

    private boolean matchesTablePattern(TablePattern tablePattern, Pair<String, IDeviceID> databaseNameAndTableName) {
        return Objects.isNull(tablePattern) || tablePattern.isTableModelDataAllowedToBeCaptured() && tablePattern.matchesDatabase((String)databaseNameAndTableName.getLeft()) && tablePattern.matchesTable(((IDeviceID)databaseNameAndTableName.getRight()).getTableName());
    }

    private boolean notFilteredByAccess(String userName, Pair<String, IDeviceID> databaseNameAndTableName) {
        return this.accessControl.checkCanSelectFromTable4Pipe(userName, new QualifiedObjectName((String)databaseNameAndTableName.getLeft(), ((IDeviceID)databaseNameAndTableName.getRight()).getTableName()));
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.sources.clear();
            this.deviceToSourcesCache.invalidateAll();
            this.deviceToSourcesCache.cleanUp();
            this.databaseAndTableToSourcesCache.invalidateAll();
            this.databaseAndTableToSourcesCache.cleanUp();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

