/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.TableLinearFillOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.ILinearFill;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class TableLinearFillWithGroupOperator
extends TableLinearFillOperator {
    private final List<Boolean> groupSplitter = new ArrayList<Boolean>();
    private final List<Boolean> noMoreTsBlockForCurrentGroup = new ArrayList<Boolean>();
    private final Comparator<SortKey> groupKeyComparator;
    private final TsBlockBuilder resultBuilder;
    private SortKey lastRow = null;

    public TableLinearFillWithGroupOperator(OperatorContext operatorContext, ILinearFill[] fillArray, Operator child, int helperColumnIndex, Comparator<SortKey> groupKeyComparator, List<TSDataType> dataTypes) {
        super(operatorContext, fillArray, child, helperColumnIndex);
        this.groupKeyComparator = groupKeyComparator;
        this.resultBuilder = new TsBlockBuilder(dataTypes);
    }

    @Override
    TsBlock append(int length, Column timeColumn, Column[] valueColumns) {
        for (int i = 0; i < this.outputColumnCount; ++i) {
            Column column = valueColumns[i];
            ColumnBuilder builder = this.resultBuilder.getColumnBuilder(i);
            for (int rowIndex = 0; rowIndex < length; ++rowIndex) {
                if (column.isNull(rowIndex)) {
                    builder.appendNull();
                    continue;
                }
                builder.write(column, rowIndex);
            }
        }
        this.resultBuilder.declarePositions(length);
        return null;
    }

    @Override
    TsBlock buildFinalResult(TsBlock tempResult) {
        TsBlock result = null;
        if (!this.resultBuilder.isEmpty()) {
            RunLengthEncodedColumn timeColumn = new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.resultBuilder.getPositionCount());
            result = this.resultBuilder.build((Column)timeColumn);
            this.resultBuilder.reset();
        }
        return result;
    }

    @Override
    boolean noMoreTsBlockForCurrentGroup() {
        return this.noMoreTsBlock || this.noMoreTsBlockForCurrentGroup.get(0) != false;
    }

    @Override
    void resetFill() {
        if (Boolean.TRUE.equals(this.groupSplitter.remove(0))) {
            for (ILinearFill fill : this.fillArray) {
                fill.reset();
            }
        }
        this.noMoreTsBlockForCurrentGroup.remove(0);
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.lastRow = null;
    }

    @Override
    void updateCachedData(TsBlock tsBlock) {
        boolean isFirstGroupOfCurrentTsBlock = true;
        SortKey currentGroupKey = new SortKey(tsBlock, 0);
        int size = tsBlock.getPositionCount();
        for (int i = 1; i < size; ++i) {
            SortKey nextGroupKey = new SortKey(tsBlock, i);
            if (this.groupKeyComparator.compare(currentGroupKey, nextGroupKey) == 0) continue;
            int length = i - currentGroupKey.rowIndex;
            TsBlock currentGroup = tsBlock.getRegion(currentGroupKey.rowIndex, length);
            super.updateCachedData(currentGroup);
            if (isFirstGroupOfCurrentTsBlock) {
                isFirstGroupOfCurrentTsBlock = false;
                boolean isNewGroup = this.isNewGroup(currentGroupKey);
                if (isNewGroup && !this.noMoreTsBlockForCurrentGroup.isEmpty()) {
                    this.noMoreTsBlockForCurrentGroup.set(this.noMoreTsBlockForCurrentGroup.size() - 1, true);
                }
                this.groupSplitter.add(isNewGroup);
            } else {
                this.groupSplitter.add(true);
            }
            this.noMoreTsBlockForCurrentGroup.add(true);
            currentGroupKey = nextGroupKey;
        }
        int length = size - currentGroupKey.rowIndex;
        TsBlock currentGroup = tsBlock.getRegion(currentGroupKey.rowIndex, length);
        super.updateCachedData(currentGroup);
        if (isFirstGroupOfCurrentTsBlock) {
            boolean isNewGroup = this.isNewGroup(currentGroupKey);
            if (isNewGroup && !this.noMoreTsBlockForCurrentGroup.isEmpty()) {
                this.noMoreTsBlockForCurrentGroup.set(this.noMoreTsBlockForCurrentGroup.size() - 1, true);
            }
            this.groupSplitter.add(isNewGroup);
        } else {
            this.groupSplitter.add(true);
        }
        this.noMoreTsBlockForCurrentGroup.add(false);
        this.lastRow = currentGroupKey;
    }

    private boolean isNewGroup(SortKey currentGroupKey) {
        return this.lastRow == null || this.groupKeyComparator.compare(this.lastRow, currentGroupKey) != 0;
    }
}

