/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.util.LDAPSDKException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AuditLogException
extends LDAPSDKException {
    private static final long serialVersionUID = -3928437646247214211L;
    @NotNull
    private final List<String> logMessageLines;

    public AuditLogException(@NotNull List<String> logMessageLines, @NotNull String explanation) {
        this(logMessageLines, explanation, null);
    }

    public AuditLogException(@NotNull List<String> logMessageLines, @NotNull String explanation, @Nullable Throwable cause) {
        super(explanation, cause);
        Validator.ensureNotNull(logMessageLines);
        Validator.ensureNotNull(explanation);
        this.logMessageLines = Collections.unmodifiableList(new ArrayList<String>(logMessageLines));
    }

    @NotNull
    public List<String> getLogMessageLines() {
        return this.logMessageLines;
    }
}

