/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.server.blob.deduplication.DeDuplicationBlobStore;
import org.apache.james.server.blob.deduplication.PassThroughBlobStore;
import org.apache.james.server.blob.deduplication.StorageStrategy;

public abstract class BlobStoreFactory {
    public static RequireBlobStoreDAO builder() {
        return blobStoreDAO -> blobIdFactory -> defaultBucketName -> storageStrategy -> {
            switch (storageStrategy) {
                case PASSTHROUGH: {
                    return new PassThroughBlobStore(blobStoreDAO, defaultBucketName, blobIdFactory);
                }
                case DEDUPLICATION: {
                    return new DeDuplicationBlobStore(blobStoreDAO, defaultBucketName, blobIdFactory);
                }
            }
            throw new IllegalArgumentException("Unknown storage strategy");
        };
    }

    @FunctionalInterface
    public static interface RequireStoringStrategy {
        public BlobStore strategy(StorageStrategy var1);

        default public BlobStore passthrough() {
            return this.strategy(StorageStrategy.PASSTHROUGH);
        }

        default public BlobStore deduplication() {
            return this.strategy(StorageStrategy.DEDUPLICATION);
        }
    }

    @FunctionalInterface
    public static interface RequireBucketName {
        public RequireStoringStrategy bucket(BucketName var1);

        default public RequireStoringStrategy defaultBucketName() {
            return this.bucket(BucketName.DEFAULT);
        }
    }

    @FunctionalInterface
    public static interface RequireBlobIdFactory {
        public RequireBucketName blobIdFactory(BlobId.Factory var1);
    }

    @FunctionalInterface
    public static interface RequireBlobStoreDAO {
        public RequireBlobIdFactory blobStoreDAO(BlobStoreDAO var1);
    }
}

