/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1BigInteger;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.DecodedPrivateKey;
import com.unboundid.util.ssl.cert.RSAPrivateKeyVersion;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RSAPrivateKey
extends DecodedPrivateKey {
    private static final long serialVersionUID = -7101141316095373904L;
    @NotNull
    private final BigInteger coefficient;
    @NotNull
    private final BigInteger exponent1;
    @NotNull
    private final BigInteger exponent2;
    @NotNull
    private final BigInteger modulus;
    @NotNull
    private final BigInteger prime1;
    @NotNull
    private final BigInteger prime2;
    @NotNull
    private final BigInteger privateExponent;
    @NotNull
    private final BigInteger publicExponent;
    @NotNull
    private final List<BigInteger[]> otherPrimeInfos;
    @NotNull
    private final RSAPrivateKeyVersion version;

    RSAPrivateKey(@NotNull RSAPrivateKeyVersion version, @NotNull BigInteger modulus, @NotNull BigInteger publicExponent, @NotNull BigInteger privateExponent, @NotNull BigInteger prime1, @NotNull BigInteger prime2, @NotNull BigInteger exponent1, @NotNull BigInteger exponent2, @NotNull BigInteger coefficient, @NotNull List<BigInteger[]> otherPrimeInfos) {
        this.version = version;
        this.modulus = modulus;
        this.publicExponent = publicExponent;
        this.privateExponent = privateExponent;
        this.prime1 = prime1;
        this.prime2 = prime2;
        this.exponent1 = exponent1;
        this.exponent2 = exponent2;
        this.coefficient = coefficient;
        this.otherPrimeInfos = otherPrimeInfos;
    }

    RSAPrivateKey(@NotNull ASN1OctetString encodedPrivateKey) throws CertException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(encodedPrivateKey.getValue()).elements();
            int versionIntValue = elements[0].decodeAsInteger().intValue();
            this.version = RSAPrivateKeyVersion.valueOf(versionIntValue);
            if (this.version == null) {
                throw new CertException(CertMessages.ERR_RSA_PRIVATE_KEY_UNSUPPORTED_VERSION.get(versionIntValue));
            }
            this.modulus = elements[1].decodeAsBigInteger().getBigIntegerValue();
            this.publicExponent = elements[2].decodeAsBigInteger().getBigIntegerValue();
            this.privateExponent = elements[3].decodeAsBigInteger().getBigIntegerValue();
            this.prime1 = elements[4].decodeAsBigInteger().getBigIntegerValue();
            this.prime2 = elements[5].decodeAsBigInteger().getBigIntegerValue();
            this.exponent1 = elements[6].decodeAsBigInteger().getBigIntegerValue();
            this.exponent2 = elements[7].decodeAsBigInteger().getBigIntegerValue();
            this.coefficient = elements[8].decodeAsBigInteger().getBigIntegerValue();
            if (elements.length == 9) {
                this.otherPrimeInfos = Collections.emptyList();
            } else {
                ASN1Element[] otherPrimesElements = elements[9].decodeAsSequence().elements();
                ArrayList<BigInteger[]> otherPrimes = new ArrayList<BigInteger[]>(otherPrimesElements.length);
                for (ASN1Element e : otherPrimesElements) {
                    ASN1Element[] primeElements = e.decodeAsSequence().elements();
                    otherPrimes.add(new BigInteger[]{primeElements[0].decodeAsBigInteger().getBigIntegerValue(), primeElements[1].decodeAsBigInteger().getBigIntegerValue(), primeElements[2].decodeAsBigInteger().getBigIntegerValue()});
                }
                this.otherPrimeInfos = Collections.unmodifiableList(otherPrimes);
            }
        }
        catch (CertException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_RSA_PRIVATE_KEY_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    ASN1OctetString encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(9);
        elements.add(new ASN1Integer(this.version.getIntValue()));
        elements.add(new ASN1BigInteger(this.modulus));
        elements.add(new ASN1BigInteger(this.publicExponent));
        elements.add(new ASN1BigInteger(this.privateExponent));
        elements.add(new ASN1BigInteger(this.prime1));
        elements.add(new ASN1BigInteger(this.prime2));
        elements.add(new ASN1BigInteger(this.exponent1));
        elements.add(new ASN1BigInteger(this.exponent2));
        elements.add(new ASN1BigInteger(this.coefficient));
        if (!this.otherPrimeInfos.isEmpty()) {
            ArrayList<ASN1Sequence> otherElements = new ArrayList<ASN1Sequence>(this.otherPrimeInfos.size());
            for (BigInteger[] info : this.otherPrimeInfos) {
                otherElements.add(new ASN1Sequence(new ASN1BigInteger(info[0]), new ASN1BigInteger(info[1]), new ASN1BigInteger(info[2])));
            }
            elements.add(new ASN1Sequence(otherElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public RSAPrivateKeyVersion getVersion() {
        return this.version;
    }

    @NotNull
    public BigInteger getModulus() {
        return this.modulus;
    }

    @NotNull
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @NotNull
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @NotNull
    public BigInteger getPrime1() {
        return this.prime1;
    }

    @NotNull
    public BigInteger getPrime2() {
        return this.prime2;
    }

    @NotNull
    public BigInteger getExponent1() {
        return this.exponent1;
    }

    @NotNull
    public BigInteger getExponent2() {
        return this.exponent2;
    }

    @NotNull
    public BigInteger getCoefficient() {
        return this.coefficient;
    }

    @NotNull
    public List<BigInteger[]> getOtherPrimeInfos() {
        return this.otherPrimeInfos;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("RSAPrivateKey(version='");
        buffer.append(this.version.getName());
        buffer.append("', modulus=");
        StaticUtils.toHex(this.modulus.toByteArray(), ":", buffer);
        buffer.append(", publicExponent=");
        StaticUtils.toHex(this.publicExponent.toByteArray(), ":", buffer);
        buffer.append(", privateExponent=");
        StaticUtils.toHex(this.privateExponent.toByteArray(), ":", buffer);
        buffer.append(", prime1=");
        StaticUtils.toHex(this.prime1.toByteArray(), ":", buffer);
        buffer.append(", prime2=");
        StaticUtils.toHex(this.prime2.toByteArray(), ":", buffer);
        buffer.append(", exponent1=");
        StaticUtils.toHex(this.exponent1.toByteArray(), ":", buffer);
        buffer.append(", exponent2=");
        StaticUtils.toHex(this.exponent2.toByteArray(), ":", buffer);
        buffer.append(", coefficient=");
        StaticUtils.toHex(this.coefficient.toByteArray(), ":", buffer);
        if (!this.otherPrimeInfos.isEmpty()) {
            buffer.append(", otherPrimeInfos={");
            Iterator<BigInteger[]> iterator = this.otherPrimeInfos.iterator();
            while (iterator.hasNext()) {
                BigInteger[] array = iterator.next();
                buffer.append("PrimeInfo(prime=");
                StaticUtils.toHex(array[0].toByteArray(), ":", buffer);
                buffer.append(", exponent=");
                StaticUtils.toHex(array[1].toByteArray(), ":", buffer);
                buffer.append(", coefficient=");
                StaticUtils.toHex(array[2].toByteArray(), ":", buffer);
                buffer.append(')');
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

