/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.james.mailbox.model.MailboxACL;

public class ACLDiff {
    private final MailboxACL oldACL;
    private final MailboxACL newACL;

    public static ACLDiff computeDiff(MailboxACL oldACL, MailboxACL newACL) {
        return new ACLDiff(oldACL, newACL);
    }

    public ACLDiff(MailboxACL oldACL, MailboxACL newACL) {
        this.oldACL = oldACL;
        this.newACL = newACL;
    }

    public Stream<MailboxACL.Entry> addedEntries() {
        return this.newACL.getEntries().entrySet().stream().filter(entry -> !this.oldACL.getEntries().containsKey(entry.getKey())).map(entry -> new MailboxACL.Entry((MailboxACL.EntryKey)entry.getKey(), (MailboxACL.Rfc4314Rights)entry.getValue()));
    }

    public Stream<MailboxACL.Entry> removedEntries() {
        return this.oldACL.getEntries().entrySet().stream().filter(entry -> !this.newACL.getEntries().containsKey(entry.getKey())).map(entry -> new MailboxACL.Entry((MailboxACL.EntryKey)entry.getKey(), (MailboxACL.Rfc4314Rights)entry.getValue()));
    }

    public Stream<MailboxACL.Entry> changedEntries() {
        Map<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> oldEntries = this.oldACL.getEntries();
        return this.newACL.getEntries().entrySet().stream().filter(entry -> this.hasKeyWithDifferentValue(oldEntries, (Map.Entry<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights>)entry)).map(entry -> new MailboxACL.Entry((MailboxACL.EntryKey)entry.getKey(), (MailboxACL.Rfc4314Rights)entry.getValue()));
    }

    private boolean hasKeyWithDifferentValue(Map<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> oldEntries, Map.Entry<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> entry) {
        return oldEntries.containsKey(entry.getKey()) && !oldEntries.get(entry.getKey()).equals(entry.getValue());
    }

    public MailboxACL getOldACL() {
        return this.oldACL;
    }

    public MailboxACL getNewACL() {
        return this.newACL;
    }

    public final boolean equals(Object o) {
        if (o instanceof ACLDiff) {
            ACLDiff aclDiff = (ACLDiff)o;
            return Objects.equals(this.oldACL, aclDiff.oldACL) && Objects.equals(this.newACL, aclDiff.newACL);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.oldACL, this.newACL);
    }
}

