/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.components;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.function.Function;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CassandraTable {
    private final Function<CassandraTypesProvider, CreateTableWithOptions> createStatement;
    private final String name;

    public CassandraTable(String name, Function<CassandraTypesProvider, CreateTableWithOptions> createStatement) {
        this.createStatement = createStatement;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Mono<InitializationStatus> initialize(KeyspaceMetadata keyspaceMetadata, CqlSession session, CassandraTypesProvider typesProvider) {
        if (keyspaceMetadata.getTable(this.name).isPresent()) {
            return Mono.just((Object)((Object)InitializationStatus.ALREADY_DONE));
        }
        return Mono.from((Publisher)session.executeReactive(this.createStatement.apply(typesProvider).build().setExecutionProfile(JamesExecutionProfiles.getTableCreationProfile(session)))).thenReturn((Object)InitializationStatus.FULL);
    }

    public final boolean equals(Object o) {
        if (o instanceof CassandraTable) {
            CassandraTable that = (CassandraTable)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.createStatement, that.createStatement);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.createStatement);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("createStatement", this.createStatement).toString();
    }

    public static enum InitializationStatus {
        ALREADY_DONE,
        PARTIAL,
        FULL;


        public InitializationStatus reduce(InitializationStatus other) {
            if (this == other) {
                return this;
            }
            return PARTIAL;
        }
    }
}

