/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.TimeUnit;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Measures message delivery times")
public class TIME
extends Protocol {
    protected final AverageMinMax up_delivery = new AverageMinMax();
    protected final AverageMinMax down_delivery = new AverageMinMax();
    @Property(description="Enables or disables measuring times in the up direction")
    protected boolean up = true;
    @Property(description="Enables or disables measuring times in the down direction")
    protected boolean down;

    @ManagedAttribute(description="Average down delivery time (in microseconds). This is computed as the average delivery time for sending a messages down, until the call returns", type=AttributeType.TIME, unit=TimeUnit.MICROSECONDS)
    public double getAvgDownDeliveryTime() {
        return this.down_delivery.average();
    }

    @ManagedAttribute(description="Average delivery time (in microseconds). This is computed as the average delivery time for single messages, plus the delivery time for batches up the stack, until the call returns", type=AttributeType.TIME, unit=TimeUnit.MICROSECONDS)
    public double getAvgUpDeliveryTime() {
        return this.up_delivery.average();
    }

    @Override
    public void resetStats() {
        this.down_delivery.clear();
        this.up_delivery.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Message msg) {
        if (!this.down) {
            return this.down_prot.down(msg);
        }
        long start = Util.micros();
        try {
            Object object = this.down_prot.down(msg);
            return object;
        }
        finally {
            long time = Util.micros() - start;
            this.down_delivery.add(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Message msg) {
        if (!this.up) {
            return this.up_prot.up(msg);
        }
        long start = Util.micros();
        try {
            Object object = this.up_prot.up(msg);
            return object;
        }
        finally {
            long time = Util.micros() - start;
            this.up_delivery.add(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(MessageBatch batch) {
        if (!this.up) {
            this.up_prot.up(batch);
            return;
        }
        long start = Util.micros();
        try {
            this.up_prot.up(batch);
        }
        finally {
            long time = Util.micros() - start;
            this.up_delivery.add(time);
        }
    }
}

