/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.transcode;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.james.managesieve.api.ArgumentException;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.api.SessionTerminatedException;
import org.apache.james.managesieve.api.commands.CoreCommands;
import org.apache.james.managesieve.transcode.NotEnoughDataException;
import org.apache.james.managesieve.util.ParserUtils;

public class ArgumentParser {
    private final CoreCommands core;
    private final boolean validatePutSize;

    @Inject
    public ArgumentParser(CoreCommands core) {
        this.core = core;
        this.validatePutSize = true;
    }

    public ArgumentParser(CoreCommands core, boolean validatePutSize) {
        this.core = core;
        this.validatePutSize = validatePutSize;
    }

    public String getAdvertisedCapabilities() {
        return this.core.getAdvertisedCapabilities();
    }

    public String capability(Session session, String args) {
        if (!args.trim().isEmpty()) {
            return "NO \"Too many arguments: " + args + "\"";
        }
        return this.core.capability(session);
    }

    public String noop(String args) {
        return this.core.noop(args);
    }

    public String unauthenticate(Session session, String args) {
        if (Strings.isNullOrEmpty((String)args)) {
            return this.core.unauthenticate(session);
        }
        return "NO UNAUTHENTICATE do not take arguments";
    }

    public void logout() throws SessionTerminatedException {
        this.core.logout();
    }

    public String chooseMechanism(Session session, String mechanism) {
        return this.core.chooseMechanism(session, mechanism);
    }

    public String authenticate(Session session, String suppliedData) {
        return this.core.authenticate(session, suppliedData);
    }

    public String deleteScript(Session session, String args) {
        Iterator argumentIterator = Splitter.on((char)' ').omitEmptyStrings().split((CharSequence)args).iterator();
        if (!argumentIterator.hasNext()) {
            return "NO \"Missing argument: script name\"";
        }
        String scriptName = ParserUtils.unquote((String)argumentIterator.next());
        if (argumentIterator.hasNext()) {
            return "NO \"Too many arguments: " + (String)argumentIterator.next() + "\"";
        }
        return this.core.deleteScript(session, scriptName);
    }

    public String getScript(Session session, String args) {
        Iterator argumentIterator = Splitter.on((char)' ').omitEmptyStrings().split((CharSequence)args).iterator();
        if (!argumentIterator.hasNext()) {
            return "NO \"Missing argument: script name\"";
        }
        String scriptName = ParserUtils.unquote((String)argumentIterator.next());
        if (argumentIterator.hasNext()) {
            return "NO \"Too many arguments: " + (String)argumentIterator.next() + "\"";
        }
        return this.core.getScript(session, scriptName);
    }

    public String checkScript(Session session, String args) {
        long size;
        Iterator firstLine = Splitter.on((String)"\r\n").split((CharSequence)args.trim()).iterator();
        Iterator arguments = Splitter.on((char)' ').split((CharSequence)((String)firstLine.next()).trim()).iterator();
        if (!arguments.hasNext()) {
            return "NO : Missing argument: script size";
        }
        try {
            size = ParserUtils.getSize((String)arguments.next());
        }
        catch (ArgumentException e) {
            return "NO \"" + e.getMessage() + "\"";
        }
        if (arguments.hasNext()) {
            return "NO \"Extra arguments not supported\"";
        }
        Object content = Joiner.on((String)"\r\n").join(firstLine);
        if (this.validatePutSize) {
            content = (String)content + "\r\n";
        }
        if ((long)((String)content).length() < size && this.validatePutSize) {
            throw new NotEnoughDataException();
        }
        if (Strings.isNullOrEmpty((String)content)) {
            return "NO \"Missing argument: script content\"";
        }
        return this.core.checkScript(session, (String)content);
    }

    public String haveSpace(Session session, String args) {
        long size;
        Iterator argumentIterator = Splitter.on((char)' ').omitEmptyStrings().split((CharSequence)args.trim()).iterator();
        if (!argumentIterator.hasNext()) {
            return "NO \"Missing argument: script name\"";
        }
        String scriptName = ParserUtils.unquote((String)argumentIterator.next());
        if (!argumentIterator.hasNext()) {
            return "NO \"Missing argument: script size\"";
        }
        try {
            size = Long.parseLong((String)argumentIterator.next());
        }
        catch (NumberFormatException e) {
            return "NO \"Invalid argument: script size\"";
        }
        if (argumentIterator.hasNext()) {
            return "NO \"Too many arguments: " + ((String)argumentIterator.next()).trim() + "\"";
        }
        return this.core.haveSpace(session, scriptName, size);
    }

    public String listScripts(Session session, String args) {
        if (!args.trim().isEmpty()) {
            return "NO \"Too many arguments: " + args + "\"";
        }
        return this.core.listScripts(session);
    }

    public String putScript(Session session, String args) {
        long size;
        Iterator firstLine = Splitter.on((String)"\r\n").split((CharSequence)args.trim()).iterator();
        Iterator arguments = Splitter.on((char)' ').split((CharSequence)((String)firstLine.next()).trim()).iterator();
        if (!arguments.hasNext()) {
            return "NO \"Missing argument: script name\"";
        }
        String scriptName = ParserUtils.unquote((String)arguments.next());
        if (Strings.isNullOrEmpty((String)scriptName)) {
            return "NO \"Missing argument: script name\"";
        }
        if (!arguments.hasNext()) {
            return "NO \"Missing argument: script size\"";
        }
        try {
            size = ParserUtils.getSize((String)arguments.next());
        }
        catch (ArgumentException e) {
            return "NO \"" + e.getMessage() + "\"";
        }
        if (arguments.hasNext()) {
            return "NO \"Extra arguments not supported\"";
        }
        Object content = Joiner.on((String)"\r\n").join(firstLine);
        if (this.validatePutSize) {
            content = (String)content + "\r\n";
        }
        if ((long)((String)content).length() < size && this.validatePutSize) {
            throw new NotEnoughDataException();
        }
        return this.core.putScript(session, ParserUtils.unquote(scriptName), (String)content);
    }

    public String renameScript(Session session, String args) {
        Iterator argumentIterator = Splitter.on((char)' ').omitEmptyStrings().split((CharSequence)args).iterator();
        if (!argumentIterator.hasNext()) {
            return "NO \"Missing argument: old script name\"";
        }
        String oldName = ParserUtils.unquote((String)argumentIterator.next());
        if (!argumentIterator.hasNext()) {
            return "NO \"Missing argument: new script name\"";
        }
        String newName = ParserUtils.unquote((String)argumentIterator.next());
        if (argumentIterator.hasNext()) {
            return "NO \"Too many arguments: " + (String)argumentIterator.next() + "\"";
        }
        return this.core.renameScript(session, oldName, newName);
    }

    public String setActive(Session session, String args) {
        Iterator argumentIterator = Splitter.on((char)' ').omitEmptyStrings().split((CharSequence)args).iterator();
        if (!argumentIterator.hasNext()) {
            return "NO \"Missing argument: script name\"";
        }
        String scriptName = ParserUtils.unquote((String)argumentIterator.next());
        if (argumentIterator.hasNext()) {
            return "NO \"Too many arguments: " + (String)argumentIterator.next() + "\"";
        }
        return this.core.setActive(session, scriptName);
    }

    public String startTLS(Session session) {
        return this.core.startTLS(session);
    }
}

