/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.ManageCertificates;
import com.unboundid.util.ssl.cert.X509Certificate;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class ManageCertificatesServerCertificateCollector
extends Thread
implements X509TrustManager {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @NotNull
    private static final java.security.cert.X509Certificate[] NO_CERTIFICATES = new java.security.cert.X509Certificate[0];
    private volatile boolean gotCertificateChain;
    private final boolean useLDAPStartTLS;
    private final boolean verbose;
    private final int port;
    @NotNull
    private final LinkedBlockingQueue<Object> queue;
    @NotNull
    private final ManageCertificates manageCertificates;
    @NotNull
    private final String hostname;

    ManageCertificatesServerCertificateCollector(@NotNull ManageCertificates manageCertificates, @NotNull String hostname, int port, boolean useLDAPStartTLS, boolean verbose, @NotNull LinkedBlockingQueue<Object> queue) {
        this.setName("ManageCertificatesServerCertificateCollector background thread for " + hostname + ':' + port);
        this.setDaemon(true);
        this.manageCertificates = manageCertificates;
        this.hostname = hostname;
        this.port = port;
        this.useLDAPStartTLS = useLDAPStartTLS;
        this.verbose = verbose;
        this.queue = queue;
        this.gotCertificateChain = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Socket nonSecureSocket;
        String hostPort = this.hostname + ':' + this.port;
        if (this.verbose) {
            this.manageCertificates.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CERT_COLLECTOR_CONNECTING.get(hostPort));
        }
        try {
            nonSecureSocket = new Socket();
            InetAddress address = LDAPConnectionOptions.DEFAULT_NAME_RESOLVER.getByName(this.hostname);
            nonSecureSocket.connect(new InetSocketAddress(address, this.port), 60000);
            if (this.verbose) {
                this.manageCertificates.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CERT_COLLECTOR_CONNECTED.get());
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            String message = CertMessages.ERR_MANAGE_CERTS_CERT_COLLECTOR_CONNECT_FAILED.get(hostPort);
            this.manageCertificates.err(new Object[0]);
            this.manageCertificates.wrapErr(0, WRAP_COLUMN, message);
            e.printStackTrace(this.manageCertificates.getErr());
            this.queue.offer(new CertException(message, e));
            return;
        }
        try {
            SSLSocket sslSocket;
            String message;
            if (this.useLDAPStartTLS) {
                LDAPMessage startTLSResponseMessage;
                if (this.verbose) {
                    this.manageCertificates.out(new Object[0]);
                    this.manageCertificates.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CERT_COLLECTOR_SENDING_START_TLS.get());
                }
                LDAPMessage startTLSRequestMessage = new LDAPMessage(1, (ProtocolOp)new ExtendedRequestProtocolOp("1.3.6.1.4.1.1466.20037", null), new Control[0]);
                try {
                    nonSecureSocket.getOutputStream().write(startTLSRequestMessage.encode().encode());
                    nonSecureSocket.getOutputStream().flush();
                    ASN1StreamReader asn1Reader = new ASN1StreamReader(nonSecureSocket.getInputStream());
                    startTLSResponseMessage = LDAPMessage.readFrom(asn1Reader, true);
                    if (startTLSResponseMessage == null) {
                        String message2 = CertMessages.ERR_MANAGE_CERTS_CERT_COLLECTOR_START_TLS_FAILED.get();
                        this.manageCertificates.wrapErr(0, WRAP_COLUMN, message2);
                        this.queue.offer(new CertException(message2));
                        return;
                    }
                }
                catch (Exception e) {
                    message = CertMessages.ERR_MANAGE_CERTS_CERT_COLLECTOR_START_TLS_FAILED.get();
                    this.manageCertificates.wrapErr(0, WRAP_COLUMN, message);
                    e.printStackTrace(this.manageCertificates.getErr());
                    this.queue.offer(new CertException(message));
                    return;
                }
                ExtendedResponseProtocolOp startTLSResponse = startTLSResponseMessage.getExtendedResponseProtocolOp();
                if (startTLSResponse.getResultCode() == 0) {
                    if (this.verbose) {
                        this.manageCertificates.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CERT_COLLECTOR_START_TLS_SUCCESSFUL.get());
                    }
                } else {
                    String message3 = CertMessages.ERR_MANAGE_CERTS_CERT_COLLECTOR_START_TLS_FAILED.get();
                    this.manageCertificates.wrapErr(0, WRAP_COLUMN, message3);
                    String[] referralURLArray = startTLSResponse.getReferralURLs().toArray(StaticUtils.NO_STRINGS);
                    Control[] responseControlArray = startTLSResponseMessage.getControls().toArray(StaticUtils.NO_CONTROLS);
                    ExtendedResult extendedResult = new ExtendedResult(startTLSRequestMessage.getMessageID(), ResultCode.valueOf(startTLSResponse.getResultCode()), startTLSResponse.getDiagnosticMessage(), startTLSResponse.getMatchedDN(), referralURLArray, startTLSResponse.getResponseOID(), startTLSResponse.getResponseValue(), responseControlArray);
                    Iterator<String> i$ = ResultUtils.formatResult(extendedResult, false, 0, WRAP_COLUMN).iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            this.queue.offer(new CertException(message3));
                            return;
                        }
                        String line = i$.next();
                        this.manageCertificates.err(line);
                    }
                }
            }
            try {
                if (this.verbose) {
                    this.manageCertificates.out(new Object[0]);
                    this.manageCertificates.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CERT_COLLECTOR_BEGINNING_TLS_NEGOTIATION.get());
                }
                SSLUtil sslUtil = new SSLUtil(this);
                sslSocket = (SSLSocket)sslUtil.createSSLSocketFactory().createSocket(nonSecureSocket, this.hostname, this.port, true);
                sslSocket.startHandshake();
                sslSocket.setSoTimeout(1000);
            }
            catch (Exception e) {
                Debug.debugException(e);
                message = CertMessages.ERR_MANAGE_CERTS_CERT_COLLECTOR_ERROR_STARTING_TLS_NEGOTIATION.get();
                this.manageCertificates.wrapErr(0, WRAP_COLUMN, message);
                e.printStackTrace(this.manageCertificates.getErr());
                this.queue.offer(new CertException(message, e));
                try {
                    nonSecureSocket.close();
                    return;
                }
                catch (Exception e2) {
                    Debug.debugException(e2);
                }
                return;
            }
            try {
                String negotiatedCipherSuite;
                long stopWaitingTime = System.currentTimeMillis() + 60000L;
                while (System.currentTimeMillis() < stopWaitingTime && !this.gotCertificateChain) {
                    try {
                        int bytesRead = sslSocket.getInputStream().read();
                        if (bytesRead >= 0 || !this.gotCertificateChain) continue;
                        return;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                if (!this.gotCertificateChain) {
                    String message4 = CertMessages.ERR_MANAGE_CERTS_CERT_COLLECTOR_NO_CERT_CHAIN_RECEIVED.get(hostPort);
                    this.manageCertificates.wrapErr(0, WRAP_COLUMN, message4);
                    this.queue.offer(new CertException(message4));
                    return;
                }
                if (!this.verbose) return;
                SSLSession sslSession = sslSocket.getSession();
                String negotiatedProtocol = sslSession.getProtocol();
                if (negotiatedProtocol != null) {
                    this.manageCertificates.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CERT_COLLECTOR_NEGOTIATED_TLS_PROTOCOL.get(negotiatedProtocol));
                }
                if ((negotiatedCipherSuite = sslSession.getCipherSuite()) == null) return;
                this.manageCertificates.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CERT_COLLECTOR_NEGOTIATED_TLS_SUITE.get(negotiatedCipherSuite));
                return;
            }
            finally {
                try {
                    sslSocket.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        finally {
            try {
                nonSecureSocket.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    @Override
    public void checkClientTrusted(@NotNull java.security.cert.X509Certificate[] chain, @NotNull String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(@NotNull java.security.cert.X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        try {
            X509Certificate[] c = new X509Certificate[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                c[i] = new X509Certificate(chain[i].getEncoded());
            }
            if (this.verbose) {
                this.manageCertificates.wrapOut(0, WRAP_COLUMN, CertMessages.INFO_MANAGE_CERTS_CERT_COLLECTOR_GOT_CERT_CHAIN.get());
            }
            this.queue.offer(c);
            this.gotCertificateChain = true;
        }
        catch (CertException ce) {
            Debug.debugException(ce);
            String message = CertMessages.ERR_MANAGE_CERTS_CERT_COLLECTOR_ERROR_PARSING_CERT_CHAIN.get(this.hostname + ':' + this.port) + ":   " + ce.getMessage();
            this.manageCertificates.wrapErr(0, WRAP_COLUMN, message);
            for (java.security.cert.X509Certificate c : chain) {
                this.manageCertificates.err(c);
            }
            this.queue.offer(new CertException(message, ce.getCause()));
            this.gotCertificateChain = true;
        }
        catch (Exception e) {
            Debug.debugException(e);
            String message = CertMessages.ERR_MANAGE_CERTS_CERT_COLLECTOR_ERROR_PARSING_CERT_CHAIN.get(this.hostname + ':' + this.port);
            this.manageCertificates.wrapErr(0, WRAP_COLUMN, message);
            e.printStackTrace(this.manageCertificates.getErr());
            this.queue.offer(new CertException(message, e));
            this.gotCertificateChain = true;
        }
    }

    @Override
    @NotNull
    public java.security.cert.X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }
}

