/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.GeneratedPassword;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GeneratePasswordExtendedResult
extends ExtendedResult {
    @NotNull
    public static final String GENERATE_PASSWORD_RESULT_OID = "1.3.6.1.4.1.30221.2.6.63";
    private static final long serialVersionUID = -6840636721723079194L;
    @NotNull
    private final List<GeneratedPassword> generatedPasswords;
    @Nullable
    private final String passwordPolicyDN;

    public GeneratePasswordExtendedResult(int messageID, @NotNull String passwordPolicyDN, @NotNull List<GeneratedPassword> generatedPasswords, Control ... controls) {
        this(messageID, ResultCode.SUCCESS, null, null, null, passwordPolicyDN, generatedPasswords, controls);
    }

    public GeneratePasswordExtendedResult(int messageID, @NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable String passwordPolicyDN, @Nullable List<GeneratedPassword> generatedPasswords, Control ... controls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, resultCode == ResultCode.SUCCESS ? GENERATE_PASSWORD_RESULT_OID : null, resultCode == ResultCode.SUCCESS ? GeneratePasswordExtendedResult.encodeValue(passwordPolicyDN, generatedPasswords) : null, controls);
        this.passwordPolicyDN = passwordPolicyDN;
        if (resultCode == ResultCode.SUCCESS) {
            this.generatedPasswords = Collections.unmodifiableList(new ArrayList<GeneratedPassword>(generatedPasswords));
        } else {
            Validator.ensureTrue(passwordPolicyDN == null, "GeneratePasswordExtendedResult.passwordPolicyDN must be null for a non-success result.");
            Validator.ensureTrue(generatedPasswords == null || generatedPasswords.isEmpty(), "GeneratePasswordExtendedResult.generatedPasswords must be null or empty for a non-success result.");
            this.generatedPasswords = Collections.emptyList();
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String passwordPolicyDN, @NotNull List<GeneratedPassword> generatedPasswords) {
        Validator.ensureNotNullOrEmpty(passwordPolicyDN, "GeneratePasswordExtendedResult.passwordPolicyDN must not be null or empty in a success result.");
        Validator.ensureNotNullOrEmpty(generatedPasswords, "GeneratePasswordExtendedResult.generatedPasswords must not be null or empty in a success result.");
        ArrayList<ASN1Sequence> passwordElements = new ArrayList<ASN1Sequence>(generatedPasswords.size());
        for (GeneratedPassword p : generatedPasswords) {
            passwordElements.add(p.encode());
        }
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1OctetString(passwordPolicyDN), new ASN1Sequence(passwordElements));
        return new ASN1OctetString(valueSequence.encode());
    }

    public GeneratePasswordExtendedResult(@NotNull ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            if (extendedResult.getResultCode() == ResultCode.SUCCESS) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GENERATE_PASSWORD_RESULT_SUCCESS_MISSING_VALUE.get());
            }
            this.passwordPolicyDN = null;
            this.generatedPasswords = Collections.emptyList();
            return;
        }
        if (extendedResult.getResultCode() != ResultCode.SUCCESS) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GENERATE_PASSWORD_RESULT_NON_SUCCESS_WITH_VALUE.get(String.valueOf(extendedResult.getResultCode())));
        }
        try {
            ASN1Element[] valueElements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.passwordPolicyDN = ASN1OctetString.decodeAsOctetString(valueElements[0]).stringValue();
            ASN1Element[] pwElements = ASN1Sequence.decodeAsSequence(valueElements[1]).elements();
            ArrayList<GeneratedPassword> pwList = new ArrayList<GeneratedPassword>(pwElements.length);
            for (ASN1Element e : pwElements) {
                pwList.add(GeneratedPassword.decode(e));
            }
            if (pwList.isEmpty()) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GENERATE_PASSWORD_RESULT_DECODE_NO_PASSWORDS.get());
            }
            this.generatedPasswords = Collections.unmodifiableList(pwList);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GENERATE_PASSWORD_RESULT_DECODING_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Nullable
    public String getPasswordPolicyDN() {
        return this.passwordPolicyDN;
    }

    @NotNull
    public List<GeneratedPassword> getGeneratedPasswords() {
        return this.generatedPasswords;
    }

    @Override
    @NotNull
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_GENERATE_PASSWORD_RESULT_NAME.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("GeneratePasswordExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if (this.passwordPolicyDN != null) {
            buffer.append(", passwordPolicyDN='");
            buffer.append(this.passwordPolicyDN);
            buffer.append('\'');
        }
        if (!this.generatedPasswords.isEmpty()) {
            buffer.append(", generatedPasswords={ ");
            Iterator<GeneratedPassword> iterator = this.generatedPasswords.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(buffer);
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(" }");
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

