/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.mailbox.DefaultMailboxes;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001B\u0006\r\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)a\u0006\u0001C\u0001_!9Q\b\u0001b\u0001\n\u0013q\u0004BB#\u0001A\u0003%q\bC\u0003G\u0001\u0011\u0005q\tC\u0003\\\u0001\u0011%A\fC\u0003e\u0001\u0011%Q\rC\u0003t\u0001\u0011%A\u000fC\u0004\u0002\n\u0001!I!a\u0003\u0003)5\u000b\u0017\u000e\u001c2pq\u0016\u001c\bK]8wSNLwN\\3s\u0015\tia\"\u0001\u0003iiR\u0004(BA\b\u0011\u0003\u0011QW.\u00199\u000b\u0005E\u0011\u0012!\u00026b[\u0016\u001c(BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fa\"\\1jY\n|\u00070T1oC\u001e,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#!\u00059Q.Y5mE>D\u0018B\u0001\u0013\"\u00059i\u0015-\u001b7c_bl\u0015M\\1hKJ\fQ\"\\3ue&\u001cg)Y2u_JL\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003\r\t\u0007/\u001b\u0006\u0003WA\tq!\\3ue&\u001c7/\u0003\u0002.Q\tiQ*\u001a;sS\u000e4\u0015m\u0019;pef\fa\u0001P5oSRtDc\u0001\u00193gA\u0011\u0011\u0007A\u0007\u0002\u0019!)ad\u0001a\u0001?!)Qe\u0001a\u0001M!\u00121!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\na!\u001b8kK\u000e$(\"\u0001\u001e\u0002\u000f)\f7.\u0019:uC&\u0011Ah\u000e\u0002\u0007\u0013:TWm\u0019;\u0002\r1{uiR#S+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\"\u0015\u0003\u0015\u0019HN\u001a\u001bk\u0013\t!\u0015I\u0001\u0004M_\u001e<WM]\u0001\b\u0019>;u)\u0012*!\u0003]\u0019'/Z1uK6\u000b\u0017\u000e\u001c2pq\u0016\u001c\u0018J\u001a(fK\u0012,G\r\u0006\u0002I-B\u0019\u0011*U*\u000e\u0003)S!a\u0013'\u0002\u0013A,(\r\\5tQ\u0016\u0014(BA\u000eN\u0015\tqu*\u0001\u0003d_J,'\"\u0001)\u0002\u000fI,\u0017m\u0019;pe&\u0011!K\u0013\u0002\u0006'6{gn\u001c\t\u00033QK!!\u0016\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006/\u001a\u0001\r\u0001W\u0001\bg\u0016\u001c8/[8o!\t\u0001\u0013,\u0003\u0002[C\tqQ*Y5mE>D8+Z:tS>t\u0017AF2sK\u0006$X\rR3gCVdG/T1jY\n|\u00070Z:\u0015\u0005!k\u0006\"\u00020\b\u0001\u0004y\u0016\u0001C;tKJt\u0017-\\3\u0011\u0005\u0001\u0014W\"A1\u000b\u00059\u0003\u0012BA2b\u0005!)6/\u001a:oC6,\u0017AE7bS2\u0014w\u000e\u001f#pKNtG/\u0012=jgR$2A\u001a6s!\rI\u0015k\u001a\t\u00033!L!!\u001b\u000e\u0003\u000f\t{w\u000e\\3b]\")1\u000e\u0003a\u0001Y\u0006YQ.Y5mE>D\b+\u0019;i!\ti\u0007/D\u0001o\u0015\ty\u0017%A\u0003n_\u0012,G.\u0003\u0002r]\nYQ*Y5mE>D\b+\u0019;i\u0011\u00159\u0006\u00021\u0001Y\u00035!x.T1jY\n|\u0007\u0010U1uQR\u0019Q/a\u0002\u0011\te1\b\u0010\\\u0005\u0003oj\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007e\f\tA\u0004\u0002{}B\u00111PG\u0007\u0002y*\u0011QPF\u0001\u0007yI|w\u000e\u001e \n\u0005}T\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0004\u0005\u0015!AB*ue&twM\u0003\u0002\u00005!)q+\u0003a\u00011\u0006i1M]3bi\u0016l\u0015-\u001b7c_b$R\u0001SA\u0007\u0003\u001fAQa\u001b\u0006A\u00021DQa\u0016\u0006A\u0002a\u0003")
public class MailboxesProvisioner {
    private final MailboxManager mailboxManager;
    private final MetricFactory metricFactory;
    private final Logger LOGGER;

    private Logger LOGGER() {
        return this.LOGGER;
    }

    public SMono<BoxedUnit> createMailboxesIfNeeded(MailboxSession session) {
        return SMono$.MODULE$.apply(this.metricFactory.decoratePublisherWithTimerMetric("JMAP-RFC-8621-mailboxes-provisioning", this.createDefaultMailboxes(session.getUser())));
    }

    private SMono<BoxedUnit> createDefaultMailboxes(Username username) {
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(DefaultMailboxes.DEFAULT_MAILBOXES).asScala()).map(this.toMailboxPath(session));
        Function1 & Serializable x$1 = (Function1 & Serializable)mailboxPath -> this.mailboxDoesntExist((MailboxPath)mailboxPath, session);
        int x$2 = qual$1.filterWhen$default$2();
        SFlux qual$2 = qual$1.filterWhen((Function1)x$1, x$2);
        Function1 & Serializable x$3 = (Function1 & Serializable)mailboxPath -> this.createMailbox((MailboxPath)mailboxPath, session);
        int x$4 = qual$2.concatMap$default$2();
        return qual$2.concatMap((Function1)x$3, x$4).then();
    }

    private SMono<Object> mailboxDoesntExist(MailboxPath mailboxPath, MailboxSession session) {
        SMono sMono;
        try {
            sMono = SMono$.MODULE$.apply(this.mailboxManager.mailboxExists(mailboxPath, session)).map((Function1 & Serializable)exist -> BoxesRunTime.boxToBoolean((boolean)MailboxesProvisioner.$anonfun$mailboxDoesntExist$1(exist)));
        }
        catch (MailboxException exception) {
            sMono = SMono$.MODULE$.error((Throwable)exception);
        }
        return sMono;
    }

    private Function1<String, MailboxPath> toMailboxPath(MailboxSession session) {
        return (Function1 & Serializable)mailbox -> MailboxPath.forUser((Username)session.getUser(), (String)mailbox);
    }

    private SMono<BoxedUnit> createMailbox(MailboxPath mailboxPath, MailboxSession session) {
        return SMono$.MODULE$.apply(this.mailboxManager.createMailboxReactive(mailboxPath, MailboxManager.CreateOption.CREATE_SUBSCRIPTION, session)).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof MailboxExistsException) {
                this.LOGGER().info("Mailbox {} have been created concurrently", (Object)mailboxPath);
                return SMono$.MODULE$.empty();
            }
            return SMono$.MODULE$.error(throwable);
        }).then();
    }

    public static final /* synthetic */ boolean $anonfun$mailboxDoesntExist$1(Boolean exist) {
        return !Predef$.MODULE$.Boolean2boolean(exist);
    }

    @Inject
    public MailboxesProvisioner(MailboxManager mailboxManager, MetricFactory metricFactory) {
        this.mailboxManager = mailboxManager;
        this.metricFactory = metricFactory;
        this.LOGGER = LoggerFactory.getLogger(MailboxesProvisioner.class);
    }
}

