/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.handler;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.observation.Observation;
import io.micrometer.observation.transport.SenderContext;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import java.net.URI;

public class PropagatingSenderTracingObservationHandler<T extends SenderContext>
implements TracingObservationHandler<T> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(PropagatingSenderTracingObservationHandler.class);
    private final Tracer tracer;
    private final Propagator propagator;

    public PropagatingSenderTracingObservationHandler(Tracer tracer, Propagator propagator) {
        this.tracer = tracer;
        this.propagator = propagator;
    }

    public void onStart(T context) {
        Span childSpan = this.createSenderSpan(context);
        this.propagator.inject(childSpan.context(), context.getCarrier(), (carrier, key, value) -> context.getSetter().set(carrier, key, value));
        this.getTracingContext(context).setSpan(childSpan);
    }

    public Span createSenderSpan(T context) {
        Span parentSpan = this.getParentSpan((Observation.ContextView)context);
        Span.Builder builder = this.getTracer().spanBuilder().kind(Span.Kind.valueOf(context.getKind().name()));
        if (parentSpan != null) {
            builder = builder.setParent(parentSpan.context());
        }
        if (context.getRemoteServiceName() != null) {
            builder = builder.remoteServiceName(context.getRemoteServiceName());
        }
        if (context.getRemoteServiceAddress() != null) {
            try {
                URI uri = URI.create(context.getRemoteServiceAddress());
                builder = builder.remoteIpAndPort(uri.getHost(), uri.getPort());
            }
            catch (Exception ex) {
                log.warn("Exception [{}], occurred while trying to parse the uri [{}] to host and port.", (Object)ex, (Object)context.getRemoteServiceAddress());
            }
        }
        return builder.start();
    }

    @Override
    public void onError(T context) {
        if (context.getError() != null) {
            this.getRequiredSpan(context).error(context.getError());
        }
    }

    public void onStop(T context) {
        Span span = this.getRequiredSpan(context);
        this.tagSpan(context, span);
        this.customizeSenderSpan(context, span);
        span.name(context.getContextualName() != null ? context.getContextualName() : context.getName());
        this.endSpan(context, span);
    }

    public void customizeSenderSpan(T context, Span span) {
    }

    @Override
    public boolean supportsContext(Observation.Context context) {
        return context instanceof SenderContext;
    }

    @Override
    public Tracer getTracer() {
        return this.tracer;
    }
}

