/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json;

import java.math.BigDecimal;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsonConfig;
import play.api.libs.json.JsonValidationError$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class BigDecimalParser$ {
    public static final BigDecimalParser$ MODULE$ = new BigDecimalParser$();

    public JsResult<BigDecimal> parse(String input, JsonConfig jsonConfig) {
        JsResult<Nothing$> jsResult;
        block4: {
            if (input.length() > jsonConfig.bigDecimalParseConfig().digitsLimit()) {
                return JsError$.MODULE$.apply("error.expected.numberdigitlimit");
            }
            try {
                BigDecimal bigDecimal = new BigDecimal(input, jsonConfig.bigDecimalParseConfig().mathContext());
                int scale = bigDecimal.scale();
                if (Math.abs(scale) > jsonConfig.bigDecimalParseConfig().scaleLimit()) {
                    jsResult = JsError$.MODULE$.apply(JsonValidationError$.MODULE$.apply("error.expected.numberscalelimit", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)scale)})));
                    break block4;
                }
                jsResult = new JsSuccess<BigDecimal>(bigDecimal, JsSuccess$.MODULE$.apply$default$2());
            }
            catch (NumberFormatException numberFormatException) {
                jsResult = JsError$.MODULE$.apply("error.expected.numberformatexception");
            }
        }
        return jsResult;
    }

    private BigDecimalParser$() {
    }
}

