/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.opensearch;

import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.opensearch.client.opensearch.cluster.HealthRequest;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import reactor.core.publisher.Mono;

public class OpenSearchHealthCheck
implements HealthCheck {
    private static final ComponentName COMPONENT_NAME = new ComponentName("OpenSearch Backend");
    private final Set<IndexName> indexNames;
    private final ReactorOpenSearchClient client;

    @Inject
    OpenSearchHealthCheck(ReactorOpenSearchClient client, Set<IndexName> indexNames) {
        this.client = client;
        this.indexNames = indexNames;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        List indices = this.indexNames.stream().map(IndexName::getValue).collect(Collectors.toList());
        HealthRequest request = new HealthRequest.Builder().index(indices).build();
        try {
            return this.client.health(request).map(this::toHealthCheckResult).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Error while contacting cluster", (Throwable)e)));
        }
        catch (IOException e2) {
            return Mono.error((Throwable)e2);
        }
    }

    @VisibleForTesting
    Result toHealthCheckResult(HealthResponse response) {
        switch (response.status()) {
            case Green: 
            case Yellow: {
                return Result.healthy((ComponentName)COMPONENT_NAME);
            }
            case Red: {
                return Result.unhealthy((ComponentName)COMPONENT_NAME, (String)(response.clusterName() + " status is RED"));
            }
        }
        throw new NotImplementedException("Un-handled OpenSearch cluster status");
    }
}

