/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Objects;
import org.apache.jena.shared.JenaException;

public enum TextDirection {
    LTR("ltr"),
    RTL("rtl");

    private final String direction;

    private TextDirection(String string2) {
        this.direction = string2;
    }

    public String direction() {
        return this.direction;
    }

    public String toString() {
        return this.direction;
    }

    public static TextDirection create(String label) {
        Objects.requireNonNull(label);
        return switch (label) {
            case "ltr" -> LTR;
            case "rtl" -> RTL;
            case "LTR", "RTL" -> throw new JenaException("Base direction must be lowercase: got: " + label);
            default -> throw new JenaException("Base direction must be 'ltr' or 'rtl'");
        };
    }

    public static TextDirection createOrNull(String label) {
        Objects.requireNonNull(label);
        return switch (label) {
            case "ltr" -> LTR;
            case "rtl" -> RTL;
            case "LTR", "RTL" -> null;
            default -> null;
        };
    }

    public static boolean isValid(String label) {
        return switch (label) {
            case "ltr", "rtl" -> true;
            default -> false;
        };
    }
}

