/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sparql.ARQNotImplemented;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.OpBase;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.SSEWriteLib;

public abstract class OpExt
extends OpBase {
    protected final String tag;

    public OpExt(String name) {
        this.tag = name;
    }

    public abstract Op effectiveOp();

    public abstract QueryIterator eval(QueryIterator var1, ExecutionContext var2);

    @Override
    public final String getName() {
        return this.tag;
    }

    @Override
    public final void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        int line = out.getRow();
        SSEWriteLib.start(out, this.tag, -1);
        this.outputArgs(out, sCxt);
        SSEWriteLib.finish(out, this.tag);
        if (line != out.getRow()) {
            out.ensureStartOfLine();
        }
    }

    public Op apply(Transform transform, OpVisitor before, OpVisitor after) {
        return this.apply(transform);
    }

    public Op apply(Transform transform) {
        throw new ARQNotImplemented("OpExt.apply(Transform)");
    }

    public abstract void outputArgs(IndentedWriter var1, SerializationContext var2);
}

