/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.nquads;

import com.apicatalog.rdf.nquads.NQuadsAlphabet;
import com.apicatalog.rdf.nquads.NQuadsReaderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class NQuadsTokenizer {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    protected final Reader reader;
    protected Token next;

    public NQuadsTokenizer(Reader reader) {
        this.reader = new BufferedReader(reader, 16384);
        this.next = null;
    }

    public NQuadsTokenizer(Reader reader, int bufferSize) {
        this.reader = new BufferedReader(reader, bufferSize);
        this.next = null;
    }

    public boolean hasNext() throws NQuadsReaderException {
        if (this.next == null) {
            this.next = this.doRead();
        }
        return TokenType.END_OF_INPUT != this.next.getType();
    }

    public Token next() throws NQuadsReaderException {
        if (!this.hasNext()) {
            return this.next;
        }
        this.next = this.doRead();
        return this.next;
    }

    public Token token() throws NQuadsReaderException {
        this.hasNext();
        return this.next;
    }

    public boolean accept(TokenType type) throws NQuadsReaderException {
        if (type == this.token().getType()) {
            this.next();
            return true;
        }
        return false;
    }

    protected Token doRead() throws NQuadsReaderException {
        try {
            int ch = this.reader.read();
            if (ch == -1) {
                return Token.EOI;
            }
            if (NQuadsAlphabet.WHITESPACE.test(ch)) {
                return this.skipWhitespaces();
            }
            if (ch == 35) {
                return this.readComment();
            }
            if (ch == 60) {
                return this.readIriRef();
            }
            if (ch == 34) {
                return this.readString();
            }
            if (ch == 46) {
                return Token.EOS;
            }
            if (NQuadsAlphabet.EOL.test(ch)) {
                return this.skipEol();
            }
            if (ch == 64) {
                return this.readLangTag();
            }
            if (ch == 95) {
                return this.readBlankNode();
            }
            if (ch == 94) {
                ch = this.reader.read();
                if (94 != ch) {
                    NQuadsTokenizer.unexpected(ch, "^");
                }
                return Token.LITERAL_DATA_TYPE;
            }
            NQuadsTokenizer.unexpected(ch, "\\t", "\\n", "\\r", "^", "@", "SPACE", ".", "<", "_", "\"", "#");
        }
        catch (IOException e) {
            throw new NQuadsReaderException(e);
        }
        throw new IllegalStateException();
    }

    protected static final void unexpected(int actual, String ... expected) throws NQuadsReaderException {
        throw new NQuadsReaderException(actual != -1 ? "Unexpected character [" + (char)actual + "] expected " + Arrays.toString(expected) + "." : "Unexpected end of input, expected " + Arrays.toString(expected) + ".");
    }

    protected Token skipWhitespaces() throws NQuadsReaderException {
        try {
            this.reader.mark(1);
            int ch = this.reader.read();
            while (NQuadsAlphabet.WHITESPACE.test(ch)) {
                this.reader.mark(1);
                ch = this.reader.read();
            }
            this.reader.reset();
            return Token.WS;
        }
        catch (IOException e) {
            throw new NQuadsReaderException(e);
        }
    }

    protected Token skipEol() throws NQuadsReaderException {
        try {
            this.reader.mark(1);
            int ch = this.reader.read();
            while (NQuadsAlphabet.EOL.test(ch)) {
                this.reader.mark(1);
                ch = this.reader.read();
            }
            this.reader.reset();
            return Token.EOL;
        }
        catch (IOException e) {
            throw new NQuadsReaderException(e);
        }
    }

    protected Token readIriRef() throws NQuadsReaderException {
        try {
            StringBuilder value = new StringBuilder();
            int ch = this.reader.read();
            while (ch != 62 && ch != -1) {
                if (0 <= ch && ch <= 32 || ch == 60 || ch == 34 || ch == 123 || ch == 125 || ch == 124 || ch == 94 || ch == 96) {
                    NQuadsTokenizer.unexpected(ch, ">");
                }
                if (ch == 92) {
                    this.readIriEscape(value);
                } else {
                    value.append((char)ch);
                }
                ch = this.reader.read();
            }
            if (ch == -1) {
                NQuadsTokenizer.unexpected(ch, new String[0]);
            }
            return new Token(TokenType.IRI_REF, value.toString());
        }
        catch (IOException e) {
            throw new NQuadsReaderException(e);
        }
    }

    protected Token readString() throws NQuadsReaderException {
        try {
            StringBuilder value = new StringBuilder();
            int ch = this.reader.read();
            while (ch != 34 && ch != -1) {
                if (ch == 10 || ch == 13) {
                    NQuadsTokenizer.unexpected(ch, new String[0]);
                }
                if (ch == 92) {
                    this.readEscape(value);
                } else {
                    value.appendCodePoint(ch);
                }
                ch = this.reader.read();
            }
            if (ch == -1) {
                NQuadsTokenizer.unexpected(ch, new String[0]);
            }
            return new Token(TokenType.STRING_LITERAL_QUOTE, value.toString());
        }
        catch (IOException e) {
            throw new NQuadsReaderException(e);
        }
    }

    protected Token readLangTag() throws NQuadsReaderException {
        try {
            StringBuilder value = new StringBuilder();
            int ch = this.reader.read();
            if (!NQuadsAlphabet.ASCII_ALPHA.test(ch) || ch == -1) {
                NQuadsTokenizer.unexpected(ch, new String[0]);
            }
            value.append((char)ch);
            this.reader.mark(1);
            ch = this.reader.read();
            while (NQuadsAlphabet.ASCII_ALPHA.test(ch)) {
                value.append((char)ch);
                this.reader.mark(1);
                ch = this.reader.read();
            }
            if (ch == -1) {
                NQuadsTokenizer.unexpected(ch, new String[0]);
            }
            boolean delim = false;
            while (NQuadsAlphabet.ASCII_ALPHA_NUM.test(ch) || ch == 45) {
                value.append((char)ch);
                this.reader.mark(1);
                ch = this.reader.read();
                delim = ch == 45;
            }
            if (ch == -1 || delim) {
                NQuadsTokenizer.unexpected(ch, new String[0]);
            }
            this.reader.reset();
            return new Token(TokenType.LANGTAG, value.toString());
        }
        catch (IOException e) {
            throw new NQuadsReaderException(e);
        }
    }

    protected void readIriEscape(StringBuilder value) throws NQuadsReaderException, IOException {
        int ch = this.reader.read();
        if (ch == 117) {
            value.append(this.readUnicode());
        } else if (ch == 85) {
            value.append(this.readUnicode64());
        } else {
            NQuadsTokenizer.unexpected(ch, new String[0]);
        }
    }

    protected void readEscape(StringBuilder value) throws NQuadsReaderException, IOException {
        int ch = this.reader.read();
        if (ch == 116 || ch == 98 || ch == 110 || ch == 114 || ch == 102 || ch == 39 || ch == 92 || ch == 34) {
            value.appendCodePoint(NQuadsTokenizer.unescape(ch));
        } else if (ch == 117) {
            value.append(this.readUnicode());
        } else if (ch == 85) {
            value.append(this.readUnicode64());
        } else {
            NQuadsTokenizer.unexpected(ch, new String[0]);
        }
    }

    protected Token readBlankNode() throws NQuadsReaderException {
        try {
            StringBuilder value = new StringBuilder();
            int ch = this.reader.read();
            if (ch != 58) {
                NQuadsTokenizer.unexpected(ch, new String[0]);
            }
            ch = this.reader.read();
            if (NQuadsAlphabet.PN_CHARS_U.negate().and(NQuadsAlphabet.ASCII_DIGIT.negate()).test(ch) || ch == -1) {
                NQuadsTokenizer.unexpected(ch, new String[0]);
            }
            value.append((char)ch);
            this.reader.mark(1);
            ch = this.reader.read();
            boolean delim = false;
            while (NQuadsAlphabet.PN_CHARS.test(ch) || ch == 46) {
                delim = ch == 46;
                value.append((char)ch);
                if (delim) {
                    this.reader.reset();
                    this.reader.mark(2);
                    this.reader.skip(1L);
                } else {
                    this.reader.mark(1);
                }
                ch = this.reader.read();
            }
            if (ch == -1) {
                NQuadsTokenizer.unexpected(ch, new String[0]);
            }
            this.reader.reset();
            if (delim && value.length() > 0) {
                value.setLength(value.length() - 1);
            }
            return new Token(TokenType.BLANK_NODE_LABEL, value.toString());
        }
        catch (IOException e) {
            throw new NQuadsReaderException(e);
        }
    }

    protected char[] readUnicode() throws NQuadsReaderException, IOException {
        char[] code = new char[]{this.readHex8(), this.readHex8(), this.readHex8(), this.readHex8()};
        return Character.toChars(Integer.parseInt(String.valueOf(code), 16));
    }

    protected char readHex8() throws IOException, NQuadsReaderException {
        int hex = this.reader.read();
        if (NQuadsAlphabet.HEX.negate().test(hex)) {
            NQuadsTokenizer.unexpected(hex, "0-9", "a-f", "A-F");
        }
        return (char)hex;
    }

    protected char[] readUnicode64() throws IOException, NQuadsReaderException {
        char[] code = new char[8];
        for (int i = 0; i < code.length; ++i) {
            code[i] = this.readHex8();
        }
        return Character.toChars(Integer.parseInt(String.valueOf(code), 16));
    }

    protected static final int unescape(int symbol) {
        if (symbol == 116) {
            return 9;
        }
        if (symbol == 98) {
            return 8;
        }
        if (symbol == 110) {
            return 10;
        }
        if (symbol == 114) {
            return 13;
        }
        if (symbol == 102) {
            return 12;
        }
        return symbol;
    }

    protected Token readComment() throws NQuadsReaderException {
        try {
            StringBuilder value = new StringBuilder();
            int ch = this.reader.read();
            while (NQuadsAlphabet.EOL.negate().test(ch) && ch != -1) {
                value.appendCodePoint(ch);
                ch = this.reader.read();
            }
            return new Token(TokenType.COMMENT, value.toString());
        }
        catch (IOException e) {
            throw new NQuadsReaderException(e);
        }
    }

    public static enum TokenType {
        LANGTAG,
        IRI_REF,
        STRING_LITERAL_QUOTE,
        BLANK_NODE_LABEL,
        WHITE_SPACE,
        LITERAL_DATA_TYPE,
        COMMENT,
        END_OF_STATEMENT,
        END_OF_LINE,
        END_OF_INPUT;

    }

    public static class Token {
        static final Token EOI = new Token(TokenType.END_OF_INPUT, null);
        static final Token EOS = new Token(TokenType.END_OF_STATEMENT, null);
        static final Token EOL = new Token(TokenType.END_OF_LINE, null);
        static final Token WS = new Token(TokenType.WHITE_SPACE, null);
        static final Token LITERAL_DATA_TYPE = new Token(TokenType.LITERAL_DATA_TYPE, null);
        final TokenType type;
        final String value;

        public Token(TokenType type, String value) {
            this.type = type;
            this.value = value;
        }

        public TokenType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "Token [type=" + (Object)((Object)this.type) + ", value=" + this.value + "]";
        }
    }
}

