/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.rest.client.RestCall;
import org.apache.juneau.rest.client.RestCallException;

public abstract class ResponsePattern {
    private Pattern pattern;

    public ResponsePattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    void match(RestCall rc) throws RestCallException {
        try {
            Matcher m = this.pattern.matcher(rc.getCapturedResponse());
            boolean found = false;
            while (m.find()) {
                this.onMatch(rc, m);
                found = true;
            }
            if (!found) {
                this.onNoMatch(rc);
            }
        }
        catch (IOException e) {
            throw new RestCallException(e);
        }
    }

    protected String getPattern() {
        return this.pattern.pattern();
    }

    public void onMatch(RestCall rc, Matcher m) throws RestCallException {
    }

    public void onNoMatch(RestCall rc) throws RestCallException {
    }
}

