/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.cockroachdb;

import java.sql.SQLException;
import org.flywaydb.core.internal.database.InsertRowLock;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.database.cockroachdb.CockroachDBRetryingStrategy;
import org.flywaydb.database.cockroachdb.CockroachDBSchema;

public class CockroachDBTable
extends Table<CockroachDBDatabase, CockroachDBSchema> {
    private final InsertRowLock insertRowLock;

    CockroachDBTable(JdbcTemplate jdbcTemplate, CockroachDBDatabase database, CockroachDBSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
        this.insertRowLock = new InsertRowLock(jdbcTemplate);
    }

    protected void doDrop() throws SQLException {
        new CockroachDBRetryingStrategy().execute(() -> {
            this.doDropOnce();
            return null;
        });
    }

    protected void doDropOnce() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE IF EXISTS " + ((CockroachDBDatabase)this.database).quote(new String[]{((CockroachDBSchema)this.schema).getName(), this.name}) + " CASCADE", new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        return (Boolean)new CockroachDBRetryingStrategy().execute(this::doExistsOnce);
    }

    protected boolean doExistsOnce() throws SQLException {
        if (((CockroachDBSchema)this.schema).cockroachDB1) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_schema = ?\n   AND    table_name = ?\n)", new String[]{((CockroachDBSchema)this.schema).getName(), this.name});
        }
        if (!((CockroachDBSchema)this.schema).hasSchemaSupport) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_catalog = ?\n   AND    table_schema = 'public'\n   AND    table_name = ?\n)", new String[]{((CockroachDBSchema)this.schema).getName(), this.name});
        }
        String sql = "SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_schema = ?\n   AND    table_name like '%" + this.name + "%' and length(table_name) = length(?)\n)";
        return this.jdbcTemplate.queryForBoolean(sql, new String[]{((CockroachDBSchema)this.schema).getName(), this.name});
    }

    protected void doLock() throws SQLException {
        String updateLockStatement = "UPDATE " + String.valueOf((Object)this) + " SET installed_on = now() WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
        String deleteExpiredLockStatement = " DELETE FROM " + String.valueOf((Object)this) + " WHERE DESCRIPTION = 'flyway-lock' AND installed_on < TIMESTAMP '?'";
        if (this.lockDepth == 0) {
            this.insertRowLock.doLock(((CockroachDBDatabase)this.database).getInsertStatement(this), updateLockStatement, deleteExpiredLockStatement, ((CockroachDBDatabase)this.database).getBooleanTrue());
        }
    }

    protected void doUnlock() throws SQLException {
        if (this.lockDepth == 1) {
            this.insertRowLock.doUnlock(this.getDeleteLockTemplate());
        }
    }

    private String getDeleteLockTemplate() {
        return "DELETE FROM " + String.valueOf((Object)this) + " WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
    }
}

