/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.net.URI;
import java.net.URISyntaxException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.support.LdapNameBuilder;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.util.Assert;

public final class LdapUtils {
    private static final Log logger = LogFactory.getLog(LdapUtils.class);

    private LdapUtils() {
    }

    public static void closeContext(Context ctx) {
        if (ctx instanceof DirContextAdapter) {
            return;
        }
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException ex) {
            logger.debug((Object)"Failed to close context.", (Throwable)ex);
        }
    }

    public static void closeEnumeration(NamingEnumeration ne) {
        try {
            if (ne != null) {
                ne.close();
            }
        }
        catch (NamingException ex) {
            logger.debug((Object)"Failed to close enumeration.", (Throwable)ex);
        }
    }

    public static String getRelativeName(String fullDn, Context baseCtx) throws NamingException {
        LdapName full;
        String baseDn = baseCtx.getNameInNamespace();
        if (baseDn.isEmpty()) {
            return fullDn;
        }
        LdapName base = LdapNameBuilder.newInstance((String)baseDn).build();
        if (base.equals(full = LdapNameBuilder.newInstance((String)fullDn).build())) {
            return "";
        }
        Assert.isTrue((boolean)full.startsWith(base), (String)"Full DN does not start with base DN");
        for (int i = 0; i < base.size(); ++i) {
            full.remove(0);
        }
        return full.toString();
    }

    public static LdapName getFullDn(LdapName dn, Context baseCtx) throws NamingException {
        LdapName baseDn = LdapNameBuilder.newInstance((String)baseCtx.getNameInNamespace()).build();
        if (dn.startsWith(baseDn)) {
            return dn;
        }
        baseDn.addAll(dn);
        return baseDn;
    }

    public static String convertPasswordToString(Object passObj) {
        Assert.notNull((Object)passObj, (String)"Password object to convert must not be null");
        if (passObj instanceof byte[]) {
            return Utf8.decode((byte[])((byte[])passObj));
        }
        if (passObj instanceof String) {
            return (String)passObj;
        }
        throw new IllegalArgumentException("Password object was not a String or byte array.");
    }

    public static String parseRootDnFromUrl(String url) {
        String urlRootDn;
        Assert.hasLength((String)url, (String)"url must have length");
        if (url.startsWith("ldap:") || url.startsWith("ldaps:")) {
            URI uri = LdapUtils.parseLdapUrl(url);
            urlRootDn = uri.getRawPath();
        } else {
            urlRootDn = url;
        }
        if (urlRootDn.startsWith("/")) {
            urlRootDn = urlRootDn.substring(1);
        }
        return urlRootDn;
    }

    private static URI parseLdapUrl(String url) {
        Assert.hasLength((String)url, (String)"url must have length");
        try {
            return new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Unable to parse url: " + url, ex);
        }
    }
}

