/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.authorization.RequiredAuthoritiesRepository;
import org.springframework.util.Assert;

public final class MapRequiredAuthoritiesRepository
implements RequiredAuthoritiesRepository {
    private final Map<String, List<String>> usernameToAuthorities = new ConcurrentHashMap<String, List<String>>();

    @Override
    public List<String> findRequiredAuthorities(String username) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        return this.usernameToAuthorities.getOrDefault(username, Collections.emptyList());
    }

    public void saveRequiredAuthorities(String username, List<String> authorities) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.notNull(authorities, (String)"authorities cannot be null");
        ArrayList<String> userAuthorities = new ArrayList<String>(authorities);
        this.usernameToAuthorities.put(username, userAuthorities);
    }

    public void deleteRequiredAuthorities(String username) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        this.usernameToAuthorities.remove(username);
    }
}

