/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.euclidean.twod.hull.ConvexHull2D;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GetBaryCenterEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    private static final long serialVersionUID = 1L;

    public GetBaryCenterEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (!(value instanceof ConvexHull2D)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for value, expecting a ConvexHull2D", this.toExpression(this.constructingFactory), value.getClass().getSimpleName()));
        }
        ConvexHull2D convexHull2D = (ConvexHull2D)value;
        Vector2D vector2D = (Vector2D)convexHull2D.createRegion().getBarycenter();
        ArrayList<Double> vec = new ArrayList<Double>();
        vec.add(vector2D.getX());
        vec.add(vector2D.getY());
        return vec;
    }
}

