/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.JoinRequest;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.internal.cluster.impl.operations.OnJoinOp;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.OperationAccessor;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandlerFactory;
import java.io.IOException;

public class JoinRequestOp
extends AbstractClusterOperation {
    private JoinRequest request;

    public JoinRequestOp() {
    }

    public JoinRequestOp(JoinRequest request) {
        this.request = request;
    }

    @Override
    public void run() {
        ClusterServiceImpl cm = (ClusterServiceImpl)this.getService();
        this.preparePreOp(this.request.getPreJoinOperation());
        cm.getClusterJoinManager().handleJoinRequest(this.request, this.getConnection());
    }

    private void preparePreOp(OnJoinOp preOp) {
        if (preOp == null) {
            return;
        }
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        preOp.setNodeEngine(nodeEngine);
        OperationAccessor.setCallerAddress(preOp, this.getCallerAddress());
        OperationAccessor.setConnection(preOp, this.getConnection());
        preOp.setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler());
    }

    public JoinRequest getRequest() {
        return this.request;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.request = (JoinRequest)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject(this.request);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", message=").append(this.request);
    }

    @Override
    public int getClassId() {
        return 13;
    }
}

