/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.converter;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.function.Function;
import org.apache.qpid.server.query.engine.evaluator.EvaluationContext;
import org.apache.qpid.server.query.engine.evaluator.EvaluationContextHolder;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.parsing.utils.StringUtils;

public final class DateTimeConverter {
    private DateTimeConverter() {
    }

    private static EvaluationContext ctx() {
        return EvaluationContextHolder.getEvaluationContext();
    }

    private static ZoneId zoneId() {
        QuerySettings querySettings = (QuerySettings)DateTimeConverter.ctx().get("query.settings");
        return querySettings.getZoneId();
    }

    private static String datePattern() {
        QuerySettings querySettings = (QuerySettings)DateTimeConverter.ctx().get("query.settings");
        return querySettings.getDatePattern();
    }

    private static String dateTimePattern() {
        QuerySettings querySettings = (QuerySettings)DateTimeConverter.ctx().get("query.settings");
        return querySettings.getDateTimePattern();
    }

    private static DateTimeFormatter dateFormatter() {
        return new DateTimeFormatterBuilder().appendPattern(DateTimeConverter.datePattern()).toFormatter().withZone(DateTimeConverter.zoneId()).withResolverStyle(ResolverStyle.STRICT);
    }

    private static DateTimeFormatter dateTimeFormatter() {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern(DateTimeConverter.dateTimePattern());
        if (!DateTimeConverter.ctx().contains("query.datetime.pattern.overriden")) {
            builder.appendFraction(ChronoField.NANO_OF_SECOND, 0, 6, true);
        }
        return builder.toFormatter().withZone(DateTimeConverter.zoneId()).withResolverStyle(ResolverStyle.STRICT);
    }

    public static String toString(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeConverter.dateTimeFormatter().format(date.toInstant());
    }

    public static String toString(Instant instant) {
        if (instant == null) {
            return null;
        }
        return DateTimeConverter.dateTimeFormatter().format(instant);
    }

    public static String toString(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return DateTimeConverter.dateFormatter().format(localDate);
    }

    public static String toString(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateTimeConverter.dateTimeFormatter().format(dateTime);
    }

    public static Instant toInstant(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant();
    }

    public static Instant toInstant(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return localDate.atStartOfDay(DateTimeConverter.zoneId()).toInstant();
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.atZone(DateTimeConverter.zoneId()).toInstant();
    }

    public static <R> boolean isDateTime(R value) {
        return value instanceof Date || value instanceof Instant || value instanceof LocalDate || value instanceof LocalDateTime;
    }

    public static <T> Function<T, String> toStringMapper() {
        return object -> {
            if (object instanceof Date) {
                return DateTimeConverter.toString((Date)object);
            }
            if (object instanceof Instant) {
                return DateTimeConverter.toString((Instant)object);
            }
            if (object instanceof LocalDate) {
                return DateTimeConverter.toString((LocalDate)object);
            }
            if (object instanceof LocalDateTime) {
                return DateTimeConverter.toString((LocalDateTime)object);
            }
            return String.valueOf(object);
        };
    }

    public static <T> Function<T, Instant> toInstantMapper() {
        return object -> {
            try {
                if (object == null) {
                    return null;
                }
                if (object instanceof Date) {
                    return DateTimeConverter.toInstant((Date)object);
                }
                if (object instanceof Instant) {
                    return (Instant)object;
                }
                if (object instanceof LocalDate) {
                    return DateTimeConverter.toInstant((LocalDate)object);
                }
                if (object instanceof LocalDateTime) {
                    return DateTimeConverter.toInstant((LocalDateTime)object);
                }
                if (object instanceof String) {
                    try {
                        return LocalDateTime.parse((String)object, DateTimeConverter.dateTimeFormatter()).atZone(DateTimeConverter.zoneId()).toInstant();
                    }
                    catch (DateTimeParseException e) {
                        try {
                            return LocalDate.parse((String)object, DateTimeConverter.dateFormatter()).atStartOfDay().atZone(DateTimeConverter.zoneId()).toInstant();
                        }
                        catch (DateTimeParseException e1) {
                            throw e;
                        }
                    }
                }
                throw QueryEvaluationException.of("Object of type '%s' can not be converted to %s", StringUtils.getClassName(object), "instant");
            }
            catch (DateTimeParseException e) {
                throw QueryEvaluationException.of(e.getMessage(), new Object[0]);
            }
        };
    }

    public static <R> Long toLong(R date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        if (date instanceof Instant) {
            return ((Instant)date).toEpochMilli();
        }
        throw QueryEvaluationException.of("Object of type '%s' can not be converted to %s", StringUtils.getClassName(date), "long");
    }

    public static DateTimeFormatter getFormatter() {
        return DateTimeConverter.dateTimeFormatter();
    }
}

