/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.datetime;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class DateExpression<T, R>
extends AbstractFunctionExpression<T, LocalDate> {
    private final FunctionParameterTypePredicate<R> _dateTimeValidator = FunctionParameterTypePredicate.builder().allowDateTimeTypes().allowNulls().allowStrings().build();

    public DateExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(1, args, this);
    }

    @Override
    public LocalDate apply(T value) {
        QuerySettings querySettings = (QuerySettings)this.ctx().get("query.settings");
        R dateTime = this.evaluateChild(0, value, this._dateTimeValidator);
        if (dateTime == null) {
            return null;
        }
        Instant instant = DateTimeConverter.toInstantMapper().apply(dateTime);
        return instant.atZone(querySettings.getZoneId()).toLocalDate();
    }
}

