/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.plugin.MessageFormat;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.ServerDecoder;
import org.apache.qpid.server.protocol.v0_10.ServerEncoder;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

@PluggableService
public class MessageFormat_0_10
implements MessageFormat<MessageTransferMessage> {
    public static final int AMQP_MESSAGE_FORMAT_0_10 = 100;

    public String getType() {
        return "AMQP_0_10";
    }

    public int getSupportedFormat() {
        return 100;
    }

    public Class<MessageTransferMessage> getMessageClass() {
        return MessageTransferMessage.class;
    }

    public QpidByteBuffer convertToMessageFormat(MessageTransferMessage message) {
        ServerEncoder encoder = new ServerEncoder(4096, true);
        Struct[] structs = message.getHeader().getStructs();
        encoder.writeInt32(structs.length);
        for (Struct struct : structs) {
            encoder.writeStruct32(struct);
        }
        try (QpidByteBuffer headerBuf = encoder.getBuffer();){
            QpidByteBuffer qpidByteBuffer;
            block13: {
                QpidByteBuffer content = message.getContent();
                try {
                    qpidByteBuffer = QpidByteBuffer.concatenate((QpidByteBuffer[])new QpidByteBuffer[]{headerBuf, content});
                    if (content == null) break block13;
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                content.close();
            }
            return qpidByteBuffer;
        }
    }

    public MessageTransferMessage createMessage(QpidByteBuffer payload, MessageStore store, Object connectionReference) {
        try {
            ServerDecoder serverDecoder = new ServerDecoder(payload);
            int headerCount = serverDecoder.readInt32();
            DeliveryProperties deliveryProperties = null;
            MessageProperties messageProperties = null;
            ArrayList<Struct> nonStandard = null;
            block6: for (int i = 0; i < headerCount; ++i) {
                Struct struct = serverDecoder.readStruct32();
                switch (struct.getStructType()) {
                    case 1025: {
                        deliveryProperties = (DeliveryProperties)struct;
                        continue block6;
                    }
                    case 1027: {
                        messageProperties = (MessageProperties)struct;
                        continue block6;
                    }
                    default: {
                        if (nonStandard == null) {
                            nonStandard = new ArrayList<Struct>();
                        }
                        nonStandard.add(struct);
                    }
                }
            }
            Header header = new Header(deliveryProperties, messageProperties, nonStandard);
            MessageMetaData_0_10 metaData = new MessageMetaData_0_10(header, payload.remaining(), System.currentTimeMillis());
            MessageHandle handle = store.addMessage((StorableMessageMetaData)metaData);
            handle.addContent(payload);
            StoredMessage storedMessage = handle.allContentAdded();
            return new MessageTransferMessage((StoredMessage<MessageMetaData_0_10>)storedMessage, connectionReference);
        }
        catch (BufferUnderflowException e) {
            throw new ConnectionScopedRuntimeException("Error parsing AMQP 0-10 message format", (Throwable)e);
        }
    }
}

