/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DumpFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import java.nio.ByteBuffer;

public class PrintFileReader
extends DumpFileReader {
    public PrintFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, long endOfFileLsn, String entryTypes, String dbIds, String txnIds, boolean verbose, boolean repEntriesOnly, boolean forwards) throws DatabaseException {
        super(env, readBufferSize, startLsn, finishLsn, endOfFileLsn, entryTypes, dbIds, txnIds, verbose, repEntriesOnly, forwards);
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        LogEntryType type = LogEntryType.findType(this.currentEntryHeader.getType());
        LogEntry entry = type.getSharedLogEntry();
        entry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
        if (!this.matchEntry(entry)) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<entry lsn=\"0x").append(Long.toHexString(this.window.currentFileNum()));
        sb.append("/0x").append(Long.toHexString(this.currentEntryOffset));
        sb.append("\" ");
        this.currentEntryHeader.dumpLogNoTag(sb, this.verbose);
        sb.append("\">");
        entry.dumpEntry(sb, this.verbose);
        sb.append("</entry>");
        System.out.println(sb.toString());
        return true;
    }
}

