/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.utilint.IntegralLongAvg;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;

public class IntegralLongAvgStat
extends Stat<IntegralLongAvg> {
    private static final long serialVersionUID = 1L;
    private IntegralLongAvg value;

    public IntegralLongAvgStat(StatGroup group, StatDefinition definition, long numerator, long denominator, long factor) {
        super(group, definition);
        this.value = new IntegralLongAvg(numerator, denominator, factor);
    }

    public IntegralLongAvgStat(StatGroup group, StatDefinition definition, long numerator, long denominator) {
        super(group, definition);
        this.value = new IntegralLongAvg(numerator, denominator);
    }

    @Override
    public IntegralLongAvg get() {
        return this.value;
    }

    @Override
    public void set(IntegralLongAvg newValue) {
        this.value = newValue;
    }

    @Override
    public void add(Stat<IntegralLongAvg> otherStat) {
        this.value.add((IntegralLongAvg)otherStat.get());
    }

    @Override
    public Stat<IntegralLongAvg> computeInterval(Stat<IntegralLongAvg> base) {
        IntegralLongAvgStat ret = this.copy();
        ret.value.subtract((IntegralLongAvg)base.get());
        return ret;
    }

    @Override
    public void negate() {
        if (this.value != null) {
            this.value.setDenominator(-this.value.getDenominator());
            this.value.setNumerator(-this.value.getNumerator());
        }
    }

    @Override
    public IntegralLongAvgStat copy() {
        try {
            IntegralLongAvgStat ret = (IntegralLongAvgStat)super.clone();
            ret.value = new IntegralLongAvg(this.value);
            return ret;
        }
        catch (CloneNotSupportedException unexpected) {
            throw EnvironmentFailureException.unexpectedException(unexpected);
        }
    }

    @Override
    public void clear() {
        this.value = null;
    }

    @Override
    protected String getFormattedValue() {
        return this.value != null ? Stat.FORMAT.format(this.get()) : Stat.FORMAT.format(0L);
    }

    @Override
    public boolean isNotSet() {
        return this.value == null;
    }
}

