/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.transport.AMQBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQFrame;
import org.apache.qpid.server.protocol.v0_8.transport.AMQProtocolVersionException;
import org.apache.qpid.server.protocol.v0_8.transport.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.protocol.v0_8.transport.BasicContentHeaderProperties;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.ContentHeaderPropertiesFactory;
import org.apache.qpid.server.transport.ByteBufferSender;

public class ContentHeaderBody
implements AMQBody {
    public static final byte TYPE = 2;
    public static final int CLASS_ID = 60;
    private static final int HEADER_SIZE = 14;
    private long _bodySize;
    private final BasicContentHeaderProperties _properties;

    public ContentHeaderBody(QpidByteBuffer buffer, long size) throws AMQFrameDecodingException {
        buffer.getUnsignedShort();
        buffer.getUnsignedShort();
        this._bodySize = buffer.getLong();
        int propertyFlags = buffer.getUnsignedShort();
        ContentHeaderPropertiesFactory factory = ContentHeaderPropertiesFactory.getInstance();
        this._properties = factory.createContentHeaderProperties(60, propertyFlags, buffer, (int)size - 14);
    }

    public ContentHeaderBody(BasicContentHeaderProperties props) {
        this._properties = props;
    }

    public ContentHeaderBody(BasicContentHeaderProperties props, long bodySize) {
        this._properties = props;
        this._bodySize = bodySize;
    }

    @Override
    public byte getFrameType() {
        return 2;
    }

    public static ContentHeaderBody createFromBuffer(QpidByteBuffer buffer, long size) throws AMQFrameDecodingException, AMQProtocolVersionException {
        ContentHeaderBody body = new ContentHeaderBody(buffer, size);
        return body;
    }

    @Override
    public int getSize() {
        return 14 + this._properties.getPropertyListSize();
    }

    @Override
    public long writePayload(ByteBufferSender sender) {
        try (QpidByteBuffer data = QpidByteBuffer.allocate((boolean)sender.isDirectBufferPreferred(), (int)14);){
            data.putUnsignedShort(60);
            data.putUnsignedShort(0);
            data.putLong(this._bodySize);
            data.putUnsignedShort(this._properties.getPropertyFlags());
            data.flip();
            sender.send(data);
        }
        return 14L + this._properties.writePropertyListPayload(sender);
    }

    public long writePayload(QpidByteBuffer buf) {
        buf.putUnsignedShort(60);
        buf.putUnsignedShort(0);
        buf.putLong(this._bodySize);
        buf.putUnsignedShort(this._properties.getPropertyFlags());
        return 14L + this._properties.writePropertyListPayload(buf);
    }

    @Override
    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws QpidException {
        session.contentHeaderReceived(channelId, this);
    }

    public static AMQFrame createAMQFrame(int channelId, BasicContentHeaderProperties properties, long bodySize) {
        return new AMQFrame(channelId, new ContentHeaderBody(properties, bodySize));
    }

    public BasicContentHeaderProperties getProperties() {
        return this._properties;
    }

    public String toString() {
        return "ContentHeaderBody{classId=60, weight=0, bodySize=" + this._bodySize + ", properties=" + String.valueOf(this._properties) + "}";
    }

    public int getClassId() {
        return 60;
    }

    public int getWeight() {
        return 0;
    }

    public long getBodySize() {
        return this._bodySize;
    }

    public void setBodySize(long bodySize) {
        this._bodySize = bodySize;
    }

    public static void process(QpidByteBuffer buffer, ChannelMethodProcessor methodProcessor, long size) throws AMQFrameDecodingException {
        int classId = buffer.getUnsignedShort();
        buffer.getUnsignedShort();
        long bodySize = buffer.getLong();
        int propertyFlags = buffer.getUnsignedShort();
        if (classId != 60) {
            throw new AMQFrameDecodingException("Unsupported content header class id: " + classId, null);
        }
        BasicContentHeaderProperties properties = new BasicContentHeaderProperties(buffer, propertyFlags, (int)(size - 14L));
        if (!methodProcessor.ignoreAllButCloseOk()) {
            methodProcessor.receiveMessageHeader(properties, bodySize);
        } else {
            properties.dispose();
        }
    }

    public void dispose() {
        this._properties.dispose();
    }

    public void clearEncodedForm() {
        this._properties.clearEncodedForm();
    }

    public void reallocate() {
        this._properties.reallocate();
    }
}

