/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.io;

import flex2.compiler.io.VirtualFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public final class FileUtil {
    public static final boolean caseInsensitive = System.getProperty("os.name").toLowerCase().startsWith("windows") || System.getProperty("os.name").toLowerCase().startsWith("mac");

    public static File openFile(String path) {
        try {
            return new File(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File openFile(String path, boolean mkdir) {
        File f = new File(path).getAbsoluteFile();
        if (mkdir) {
            new File(f.getParent()).mkdirs();
        }
        return f;
    }

    public static File openFile(File parentPath, String fileName) {
        try {
            return new File(parentPath, fileName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File createTempFile(InputStream in) throws IOException {
        File temp = File.createTempFile("Flex2_", "");
        FileUtil.writeBinaryFile(temp, in);
        return temp;
    }

    public static InputStream openStream(File file) throws FileNotFoundException, IOException {
        return FileUtil.openStream(file.getAbsolutePath());
    }

    public static InputStream openStream(String path) throws FileNotFoundException, IOException {
        return FileUtil.openStream(new FileInputStream(path));
    }

    public static InputStream openStream(InputStream in) throws IOException {
        byte[] bom = new byte[3];
        in.read(bom, 0, 3);
        if (bom[0] == 239 && bom[1] == 187 && bom[2] == 191) {
            return in;
        }
        return new BOMInputStream(bom, in);
    }

    public static void writeBinaryFile(File file, InputStream in) throws IOException {
        in = new BufferedInputStream(in);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            FileUtil.streamOutput(in, out);
        }
    }

    public static void streamOutput(InputStream in, OutputStream out) throws IOException {
        int len = 8192;
        byte[] bytes = new byte[len];
        while ((len = in.read(bytes, 0, len)) != -1) {
            out.write(bytes, 0, len);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, String output) throws FileNotFoundException, IOException {
        File file = FileUtil.openFile(fileName);
        if (file == null) {
            throw new FileNotFoundException(fileName);
        }
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));){
            out.write(output);
            ((Writer)out).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBinaryFile(String fileName, byte[] output) throws FileNotFoundException, IOException {
        File file = FileUtil.openFile(fileName);
        if (file == null) {
            throw new FileNotFoundException(fileName);
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            ((OutputStream)out).write(output);
            ((OutputStream)out).flush();
        }
    }

    public static String getCanonicalPath(String path) {
        File f = FileUtil.openFile(path);
        return f == null ? null : FileUtil.getCanonicalPath(f);
    }

    public static String getCanonicalPath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ex) {
            return f.getAbsolutePath();
        }
    }

    public static File getCanonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ex) {
            return f.getAbsoluteFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File f) {
        BufferedReader file = null;
        StringBuilder buffer = new StringBuilder((int)f.length());
        String lineSep = System.getProperty("line.separator");
        try {
            file = new BufferedReader(new InputStreamReader(FileUtil.openStream(f)));
            String s = null;
            while ((s = file.readLine()) != null) {
                buffer.append(s);
                buffer.append(lineSep);
            }
            String string = buffer.toString();
            return string;
        }
        catch (FileNotFoundException ex) {
            String string = null;
            return string;
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLine(String f, int line) {
        BufferedReader file = null;
        try {
            file = new BufferedReader(new InputStreamReader(FileUtil.openStream(f), "UTF8"));
            for (int i = 0; i < line - 1 && file.readLine() != null; ++i) {
            }
            String i = file.readLine();
            return i;
        }
        catch (FileNotFoundException ex) {
            String string = null;
            return string;
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(String f, int line) {
        BufferedInputStream in = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean lastIsCR = false;
        int pos = 0;
        int ch = 0;
        int count = 0;
        try {
            in = new BufferedInputStream(FileUtil.openStream(f));
            while ((ch = in.read()) != -1) {
                if (lastIsCR) {
                    if (line == ++count) {
                        byte[] byArray = baos.toByteArray();
                        return byArray;
                    }
                    baos.reset();
                    if (ch == 10) {
                        lastIsCR = false;
                    } else if (ch == 13) {
                        lastIsCR = true;
                    } else {
                        baos.write(ch);
                        lastIsCR = false;
                    }
                } else if (ch == 10) {
                    if (line == ++count) {
                        byte[] byArray = baos.toByteArray();
                        return byArray;
                    }
                    baos.reset();
                    lastIsCR = false;
                } else if (ch == 13) {
                    lastIsCR = true;
                } else {
                    baos.write(ch);
                    lastIsCR = false;
                }
                ++pos;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (FileNotFoundException ex) {
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int isSubdirectoryOf(File pathFile, List directories) {
        String path = pathFile.toString();
        int size = directories.size();
        for (int j = 0; j < size; ++j) {
            File dirFile = FileUtil.getCanonicalFile((File)directories.get(j));
            String dir = dirFile.toString();
            if (pathFile.getParent().equals(dirFile.getParent()) || (path.length() <= dir.length() || !path.startsWith(dir)) && (dir.length() <= path.length() || !dir.startsWith(path))) continue;
            return j;
        }
        return -1;
    }

    public static int isSubdirectoryOf(String directory, VirtualFile[] directories) {
        int size;
        File pathFile = FileUtil.openFile(directory);
        String path = pathFile.toString();
        int n = size = directories == null ? 0 : directories.length;
        for (int j = 0; j < size; ++j) {
            File dirFile = FileUtil.openFile(directories[j].getName());
            String dir = dirFile.toString();
            if (pathFile.getParent().equals(dirFile.getParent()) || path.length() <= dir.length() || !path.startsWith(dir)) continue;
            return j;
        }
        return -1;
    }

    public static String getExceptionMessage(Exception ex) {
        return FileUtil.getExceptionMessage(ex, true);
    }

    public static String getExceptionMessage(Exception ex, boolean stackDump) {
        Object m = ex.getMessage();
        if (m == null) {
            m = ex.getLocalizedMessage();
        }
        if (m == null) {
            m = "(" + ex.getClass().getName() + ")";
            if (stackDump) {
                StringWriter s = new StringWriter();
                PrintWriter p = new PrintWriter((Writer)s, true);
                ex.printStackTrace(p);
                m = (String)m + s.getBuffer().toString();
            }
        }
        return m;
    }

    private static final class BOMInputStream
    extends InputStream {
        private byte[] bom;
        private final int bomSize;
        private final InputStream in;
        private int index;

        private BOMInputStream(byte[] bom, InputStream in) {
            this.bom = bom;
            this.bomSize = bom.length;
            this.in = in;
            this.index = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.bom == null) {
                return this.in.read();
            }
            byte c = this.bom[this.index];
            if (this.index == this.bomSize - 1) {
                this.bom = null;
            }
            ++this.index;
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int count;
            if (this.bom == null) {
                return this.in.read(b, off, len);
            }
            for (count = 0; this.index < 3 && count < len; ++count) {
                b[off + count] = this.bom[this.index++];
            }
            if (this.index == 3) {
                this.bom = null;
            }
            if (len <= count) {
                return count;
            }
            int r = this.in.read(b, off + count, len - count);
            return r == -1 ? -1 : r + count;
        }

        @Override
        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException("supports read() and close() only...");
        }

        @Override
        public int available() throws IOException {
            int num = this.in.available();
            if (this.bom == null) {
                return num;
            }
            return this.bomSize - this.index + num;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            throw new UnsupportedOperationException("supports read() and close() only...");
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new UnsupportedOperationException("supports read() and close() only...");
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

