/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.query;

import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import org.apache.servicecomb.common.rest.codec.param.QueryProcessorCreator;
import org.apache.servicecomb.common.rest.codec.query.AbstractQueryCodec;
import org.apache.servicecomb.common.rest.codec.query.QueryCodec;
import org.apache.servicecomb.common.rest.definition.path.URLPathBuilder;
import org.springframework.stereotype.Component;

@Component
public class QueryCodecMulti
extends AbstractQueryCodec {
    public static final String CODEC_NAME = "multi";

    public QueryCodecMulti() {
        super(CODEC_NAME);
    }

    @Override
    public void encode(URLPathBuilder.URLPathStringBuilder builder, String name, @Nonnull Collection<Object> values) throws Exception {
        for (Object value : values) {
            if (value == null) continue;
            String strValue = QueryCodec.convertToString(value);
            builder.appendQuery(name, QueryCodec.encodeValue(strValue));
        }
    }

    @Override
    public Object decode(QueryProcessorCreator.QueryProcessor processor, HttpServletRequest request) {
        if (processor.isRepeatedType()) {
            String[] values = request.getParameterValues(processor.getParameterPath());
            return processor.convertValue(values);
        }
        Object value = processor.getAndCheckParameter(request);
        return processor.convertValue(value);
    }
}

