/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.faultinjection;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.faultinjection.FaultInjectionUtil;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerDelayFaultFilter
extends AbstractFilter
implements ConsumerFilter,
EdgeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerDelayFaultFilter.class);

    public int getOrder() {
        return 1030;
    }

    public String getName() {
        return "consumer-delay-fault";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (!this.shouldDelay(invocation)) {
            return nextNode.onFilter(invocation);
        }
        LOGGER.debug("Fault injection: delay is added for the request by fault inject handler");
        long delay = FaultInjectionUtil.getFaultInjectionConfig(invocation, "delay.fixedDelay");
        if (delay == -1L) {
            LOGGER.debug("Fault injection: delay is not configured");
            return nextNode.onFilter(invocation);
        }
        return this.executeDelay(invocation, nextNode, delay);
    }

    private CompletableFuture<Response> executeDelay(Invocation invocation, FilterNode nextNode, long delay) {
        Context currentContext = Vertx.currentContext();
        if (currentContext != null && currentContext.isEventLoopContext()) {
            CompletableFuture<Response> result = new CompletableFuture<Response>();
            currentContext.owner().setTimer(delay, timeID -> nextNode.onFilter(invocation).whenComplete((r, e) -> {
                if (e == null) {
                    result.complete((Response)r);
                } else {
                    result.completeExceptionally((Throwable)e);
                }
            }));
            return result;
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            LOGGER.info("Interrupted exception is received");
        }
        return nextNode.onFilter(invocation);
    }

    private boolean shouldDelay(Invocation invocation) {
        int delayPercent = FaultInjectionUtil.getFaultInjectionConfig(invocation, "delay.percent");
        if (delayPercent == -1) {
            LOGGER.debug("Fault injection: delay percentage is not configured");
            return false;
        }
        return FaultInjectionUtil.isFaultNeedToInject(delayPercent);
    }
}

