/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coordinate;

import java.io.Serializable;
import java.time.temporal.Temporal;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.internal.Epoch;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultCoordinateMetadata
extends FormattableObject
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -754447822292824735L;
    private final CoordinateReferenceSystem crs;
    private final Temporal epoch;

    public DefaultCoordinateMetadata(CoordinateReferenceSystem crs, Temporal epoch) {
        this.crs = Objects.requireNonNull(crs);
        this.epoch = epoch;
        if (epoch == null && CRS.getFrameReferenceEpoch(crs).isPresent()) {
            throw new IllegalArgumentException(Resources.format((short)102, IdentifiedObjects.getDisplayName((IdentifiedObject)crs, null)));
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Optional<Temporal> getCoordinateEpoch() {
        return Optional.ofNullable(this.epoch);
    }

    public int hashCode() {
        return this.crs.hashCode() * 11 + Objects.hashCode(this.epoch);
    }

    public final boolean equals(Object obj) {
        return this.equals(obj, ComparisonMode.STRICT);
    }

    public boolean equals(Object obj, ComparisonMode mode) {
        if (this == obj) {
            return true;
        }
        if (obj != null && mode == ComparisonMode.STRICT && obj.getClass() == this.getClass()) {
            DefaultCoordinateMetadata other = (DefaultCoordinateMetadata)obj;
            return this.crs.equals((Object)other.crs) && Objects.equals(this.epoch, other.epoch);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(WKTUtilities.toFormattable(this.crs));
        if (this.epoch != null) {
            formatter.append(new Epoch(this.epoch, "Epoch"));
        }
        return "CoordinateMetadata";
    }
}

