/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.transport.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.fluent.Executor;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.transport.impl.HttpTransportUtils;
import org.apache.sling.distribution.transport.impl.RemoteDistributionPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemoteDistributionPackage
implements RemoteDistributionPackage {
    private static final Logger log = LoggerFactory.getLogger(DefaultRemoteDistributionPackage.class);
    private final DistributionPackage wrappedPackage;
    private final Executor executor;
    private final URI distributionURI;
    private final String remoteId;

    public DefaultRemoteDistributionPackage(DistributionPackage wrappedPackage, Executor executor, URI distributionURI) {
        this.wrappedPackage = wrappedPackage;
        this.executor = executor;
        this.distributionURI = distributionURI;
        this.remoteId = (String)wrappedPackage.getInfo().get("remote.package.id");
    }

    @Override
    public DistributionPackage getPackage() {
        return this.wrappedPackage;
    }

    @Override
    public void deleteRemotePackage() {
        try {
            HttpTransportUtils.deletePackage(this.executor, this.distributionURI, this.remoteId);
        }
        catch (URISyntaxException e) {
            log.error("cannot delete remote package", (Throwable)e);
        }
        catch (IOException e) {
            log.error("cannot delete remote package", (Throwable)e);
        }
    }
}

