/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.persistence.meta.CompileTimeLogger;
import org.apache.openjpa.persistence.meta.MetadataProcessor;
import org.apache.openjpa.util.UserException;

public class SourceAnnotationHandler
implements MetadataProcessor<TypeElement, Element> {
    private final ProcessingEnvironment processingEnv;
    private final Types typeUtility;
    private final CompileTimeLogger logger;
    protected AccessFilter propertyAccessFilter = new AccessFilter(AccessType.PROPERTY);
    protected AccessFilter fieldAccessFilter = new AccessFilter(AccessType.FIELD);
    protected KindFilter fieldFilter = new KindFilter(ElementKind.FIELD);
    protected KindFilter methodFilter = new KindFilter(ElementKind.METHOD);
    protected TransientFilter nonTransientFilter = new TransientFilter();
    protected AnnotatedFilter annotatedFilter = new AnnotatedFilter();
    protected GetterFilter getterFilter = new GetterFilter();
    protected SetterFilter setterFilter = new SetterFilter();
    protected static List<Class<? extends Annotation>> mappingAnnos = new ArrayList<Class<? extends Annotation>>();
    private static Localizer _loc;

    public SourceAnnotationHandler(ProcessingEnvironment processingEnv, CompileTimeLogger logger) {
        this.processingEnv = processingEnv;
        this.typeUtility = processingEnv.getTypeUtils();
        this.logger = logger;
    }

    @Override
    public int determineTypeAccess(TypeElement type) {
        boolean isExplicit;
        AccessType access = this.getExplicitAccessType(type);
        boolean bl = isExplicit = access != null;
        return isExplicit ? (access == AccessType.FIELD ? AccessCode.EXPLICIT | AccessCode.FIELD : AccessCode.EXPLICIT | AccessCode.PROPERTY) : this.getImplicitAccessType(type);
    }

    @Override
    public int determineMemberAccess(Element m) {
        return 0;
    }

    @Override
    public List<Exception> validateAccess(TypeElement t) {
        return null;
    }

    @Override
    public boolean isMixedAccess(TypeElement t) {
        return false;
    }

    @Override
    public Set<Element> getPersistentMembers(TypeElement type) {
        int access = this.determineTypeAccess(type);
        if (AccessCode.isExplicit((int)access)) {
            return AccessCode.isField((int)access) ? this.getFieldAccessPersistentMembers(type) : this.getPropertyAccessPersistentMembers(type);
        }
        return this.getDefaultAccessPersistentMembers(type, access);
    }

    private Set<Element> getFieldAccessPersistentMembers(TypeElement type) {
        List<? extends Element> allMembers = type.getEnclosedElements();
        Set<? extends Element> allFields = this.filter(allMembers, this.fieldFilter, this.nonTransientFilter);
        Set<? extends Element> allMethods = this.filter(allMembers, this.methodFilter, this.nonTransientFilter);
        Set<? extends Element> getters = this.filter(allMethods, this.getterFilter, this.propertyAccessFilter, this.annotatedFilter);
        Set<? extends Element> setters = this.filter(allMethods, this.setterFilter);
        getters = this.matchGetterAndSetter(getters, setters);
        return this.merge(getters, allFields);
    }

    private Set<Element> getPropertyAccessPersistentMembers(TypeElement type) {
        List<? extends Element> allMembers = type.getEnclosedElements();
        Set<? extends Element> allMethods = this.filter(allMembers, this.methodFilter, this.nonTransientFilter);
        Set<? extends Element> getters = this.filter(allMethods, this.getterFilter);
        Set<? extends Element> setters = this.filter(allMethods, this.setterFilter);
        getters = this.matchGetterAndSetter(getters, setters);
        return this.merge(this.filter(allMembers, this.fieldFilter, this.nonTransientFilter, this.fieldAccessFilter), getters);
    }

    private Set<Element> getDefaultAccessPersistentMembers(TypeElement type, int access) {
        HashSet<Element> result = new HashSet<Element>();
        List<? extends Element> allMembers = type.getEnclosedElements();
        if (AccessCode.isField((int)access)) {
            Set<? extends Element> allFields = this.filter(allMembers, this.fieldFilter, this.nonTransientFilter);
            result.addAll(allFields);
        } else {
            Set<? extends Element> allMethods = this.filter(allMembers, this.methodFilter, this.nonTransientFilter);
            Set<? extends Element> getters = this.filter(allMethods, this.getterFilter);
            Set<? extends Element> setters = this.filter(allMethods, this.setterFilter);
            getters = this.matchGetterAndSetter(getters, setters);
            result.addAll(getters);
        }
        return result;
    }

    private int getImplicitAccessType(TypeElement type) {
        boolean isPropertyAccess;
        List<? extends Element> allMembers = type.getEnclosedElements();
        Set<? extends Element> allFields = this.filter(allMembers, this.fieldFilter, this.nonTransientFilter);
        Set<? extends Element> allMethods = this.filter(allMembers, this.methodFilter, this.nonTransientFilter);
        Set<? extends Element> annotatedFields = this.filter(allFields, this.annotatedFilter);
        Set<? extends Element> getters = this.filter(allMethods, this.getterFilter, this.annotatedFilter);
        Set<? extends Element> setters = this.filter(allMethods, this.setterFilter);
        getters = this.matchGetterAndSetter(getters, setters);
        boolean isFieldAccess = !annotatedFields.isEmpty();
        boolean bl = isPropertyAccess = !getters.isEmpty();
        if (isFieldAccess && isPropertyAccess) {
            throw new UserException(_loc.get("access-mixed", (Object)type, (Object)SourceAnnotationHandler.toString(annotatedFields), (Object)SourceAnnotationHandler.toString(getters)));
        }
        if (isFieldAccess) {
            return AccessCode.FIELD;
        }
        if (isPropertyAccess) {
            return AccessCode.PROPERTY;
        }
        TypeElement superType = this.getPersistentSupertype(type);
        return superType == null ? AccessCode.FIELD : this.determineTypeAccess(superType);
    }

    Set<Element> merge(Set<? extends Element> a, Set<? extends Element> b) {
        HashSet<Element> result = new HashSet<Element>(a);
        for (Element element : b) {
            boolean hide = false;
            String key = this.getPersistentMemberName(element);
            for (Element element2 : a) {
                if (!this.getPersistentMemberName(element2).equals(key)) continue;
                hide = true;
                break;
            }
            if (hide) continue;
            result.add(element);
        }
        return result;
    }

    private Set<ExecutableElement> matchGetterAndSetter(Set<ExecutableElement> getters, Set<ExecutableElement> setters) {
        ArrayList<ExecutableElement> unmatched = new ArrayList<ExecutableElement>();
        for (ExecutableElement getter : getters) {
            String getterName = getter.getSimpleName().toString();
            TypeMirror getterReturnType = getter.getReturnType();
            String expectedSetterName = "set" + getterName.substring((SourceAnnotationHandler.isBooleanGetter(getter) ? "is" : "get").length());
            boolean matched = false;
            for (ExecutableElement setter : setters) {
                TypeMirror setterArgType = setter.getParameters().iterator().next().asType();
                String actualSetterName = setter.getSimpleName().toString();
                matched = actualSetterName.equals(expectedSetterName) && this.typeUtility.isSameType(setterArgType, getterReturnType);
                if (!matched) continue;
                break;
            }
            if (matched) continue;
            this.logger.warn(_loc.get("getter-unmatched", (Object)getter, (Object)getter.getEnclosingElement()));
            unmatched.add(getter);
        }
        getters.removeAll(unmatched);
        return getters;
    }

    <T extends Element> Set<T> filter(Collection<T> coll, InclusiveFilter ... filters) {
        HashSet<Element> result = new HashSet<Element>();
        for (Element e : coll) {
            boolean include = true;
            for (InclusiveFilter f : filters) {
                if (f.includes(e)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            result.add(e);
        }
        return result;
    }

    AccessType getExplicitAccessType(TypeElement type) {
        Object access = SourceAnnotationHandler.getAnnotationValue(type, Access.class);
        if (SourceAnnotationHandler.equalsByValue(AccessType.FIELD, access)) {
            return AccessType.FIELD;
        }
        if (SourceAnnotationHandler.equalsByValue(AccessType.PROPERTY, access)) {
            return AccessType.PROPERTY;
        }
        return null;
    }

    public static Object getAnnotationValue(Element decl, Class<? extends Annotation> anno) {
        return SourceAnnotationHandler.getAnnotationValue(decl, anno, "value");
    }

    public static Object getAnnotationValue(Element e, Class<? extends Annotation> anno, String attr) {
        if (e == null || e.getAnnotation(anno) == null) {
            return null;
        }
        List<? extends AnnotationMirror> annos = e.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annos) {
            if (!annotationMirror.getAnnotationType().toString().equals(anno.getName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals(attr)) continue;
                return entry.getValue().getValue();
            }
        }
        return null;
    }

    public static String toString(Collection<? extends Element> elements) {
        StringBuilder tmp = new StringBuilder();
        int i = 0;
        for (Element element : elements) {
            tmp.append(element.getSimpleName() + (++i == elements.size() ? "" : ","));
        }
        return tmp.toString();
    }

    String toDetails(Element e) {
        TypeMirror mirror = e.asType();
        return e.getKind().toString() + " " + e.toString() + "Mirror " + mirror.getKind().toString() + mirror.toString();
    }

    String getPersistentMemberName(Element e) {
        return SourceAnnotationHandler.isMethod(e) ? this.extractFieldName((ExecutableElement)e) : e.getSimpleName().toString();
    }

    public String extractFieldName(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        String head = SourceAnnotationHandler.isNormalGetter(method) ? "get" : "is";
        name = name.substring(head.length());
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static boolean isAnnotated(Element e) {
        return SourceAnnotationHandler.isAnnotatedWith(e, (Set<String>)null);
    }

    boolean isAnnotatedAsEntity(Element e) {
        return SourceAnnotationHandler.isAnnotatedWith(e, Entity.class) || SourceAnnotationHandler.isAnnotatedWith(e, Embeddable.class) || SourceAnnotationHandler.isAnnotatedWith(e, MappedSuperclass.class);
    }

    public static boolean isAnnotatedWith(Element e, Class<? extends Annotation> anno) {
        return e != null && e.getAnnotation(anno) != null;
    }

    public static boolean isAnnotatedWith(Element e, Set<String> annos) {
        if (e == null) {
            return false;
        }
        List<? extends AnnotationMirror> mirrors = e.getAnnotationMirrors();
        if (annos == null) {
            for (AnnotationMirror annotationMirror : mirrors) {
                String name = annotationMirror.getAnnotationType().toString();
                if (!SourceAnnotationHandler.startsWith(name, "javax.persistence.") && !SourceAnnotationHandler.startsWith(name, "org.apache.openjpa.")) continue;
                return true;
            }
            return false;
        }
        for (AnnotationMirror annotationMirror : mirrors) {
            String name = annotationMirror.getAnnotationType().toString();
            if (!annos.contains(name)) continue;
            return true;
        }
        return false;
    }

    TypeMirror getTargetEntityType(Element e) {
        for (Class<? extends Annotation> anno : mappingAnnos) {
            Object target = SourceAnnotationHandler.getAnnotationValue(e, anno, "targetEntity");
            if (target == null) continue;
            return (TypeMirror)target;
        }
        return null;
    }

    String getDeclaredTypeName(TypeMirror mirror) {
        return this.getDeclaredTypeName(mirror, true);
    }

    String getDeclaredTypeName(TypeMirror mirror, boolean box) {
        return this.getDeclaredTypeName(mirror, box, false);
    }

    String getDeclaredTypeName(TypeMirror mirror, boolean box, boolean persistentCollection) {
        if (mirror == null || mirror.getKind() == TypeKind.NULL || mirror.getKind() == TypeKind.WILDCARD) {
            return "java.lang.Object";
        }
        if (mirror.getKind() == TypeKind.ARRAY) {
            if (persistentCollection) {
                TypeMirror comp = ((ArrayType)mirror).getComponentType();
                return this.getDeclaredTypeName(comp, false);
            }
            return mirror.toString();
        }
        TypeMirror typeMirror = mirror = box ? this.box(mirror) : mirror;
        if (this.isPrimitive(mirror)) {
            return ((PrimitiveType)mirror).toString();
        }
        Element elem = this.typeUtility.asElement(mirror);
        if (elem == null) {
            throw new RuntimeException(_loc.get("mmg-no-type", (Object)mirror).getMessage());
        }
        return elem.toString();
    }

    TypeMirror getDeclaredType(Element e) {
        TypeMirror result = null;
        switch (e.getKind()) {
            case FIELD: {
                result = e.asType();
                break;
            }
            case METHOD: {
                result = ((ExecutableElement)e).getReturnType();
                break;
            }
            default: {
                throw new IllegalArgumentException(this.toDetails(e));
            }
        }
        return result;
    }

    private boolean isPrimitive(TypeMirror mirror) {
        TypeKind kind = mirror.getKind();
        return kind == TypeKind.BOOLEAN || kind == TypeKind.BYTE || kind == TypeKind.CHAR || kind == TypeKind.DOUBLE || kind == TypeKind.FLOAT || kind == TypeKind.INT || kind == TypeKind.LONG || kind == TypeKind.SHORT;
    }

    public TypeMirror box(TypeMirror t) {
        if (this.isPrimitive(t)) {
            return this.processingEnv.getTypeUtils().boxedClass((PrimitiveType)t).asType();
        }
        return t;
    }

    TypeMirror getTypeParameter(Element e, TypeMirror mirror, int index, boolean checkTarget) {
        NullType param;
        TypeMirror target;
        if (mirror.getKind() == TypeKind.ARRAY) {
            return ((ArrayType)mirror).getComponentType();
        }
        if (mirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        if (checkTarget && (target = this.getTargetEntityType(e)) != null) {
            return target;
        }
        List<? extends TypeMirror> params = ((DeclaredType)mirror).getTypeArguments();
        TypeMirror typeMirror = param = params == null || params.size() < index + 1 ? this.typeUtility.getNullType() : params.get(index);
        if (param.getKind() == TypeKind.NULL || param.getKind() == TypeKind.WILDCARD) {
            this.logger.warn(_loc.get("generic-type-param", (Object)e, (Object)this.getDeclaredType(e), (Object)e.getEnclosingElement()));
        }
        return param;
    }

    @Override
    public TypeElement getPersistentSupertype(TypeElement cls) {
        if (cls == null) {
            return null;
        }
        TypeMirror sup = cls.getSuperclass();
        if (sup == null || sup.getKind() == TypeKind.NONE || SourceAnnotationHandler.isRootObject(sup)) {
            return null;
        }
        TypeElement supe = (TypeElement)this.processingEnv.getTypeUtils().asElement(sup);
        if (this.isAnnotatedAsEntity(supe)) {
            return supe;
        }
        return this.getPersistentSupertype(supe);
    }

    public static boolean isBoolean(TypeMirror type) {
        return type != null && (type.getKind() == TypeKind.BOOLEAN || "java.lang.Boolean".equals(type.toString()));
    }

    public static boolean isVoid(TypeMirror type) {
        return type != null && type.getKind() == TypeKind.VOID;
    }

    public static boolean isMethod(Element e) {
        return e != null && ExecutableElement.class.isInstance(e) && e.getKind() == ElementKind.METHOD;
    }

    public static boolean isNormalGetter(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return method.getKind() == ElementKind.METHOD && SourceAnnotationHandler.startsWith(methodName, "get") && method.getParameters().isEmpty() && !SourceAnnotationHandler.isVoid(method.getReturnType());
    }

    public static boolean isBooleanGetter(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return method.getKind() == ElementKind.METHOD && SourceAnnotationHandler.startsWith(methodName, "is") && method.getParameters().isEmpty() && SourceAnnotationHandler.isBoolean(method.getReturnType());
    }

    public static boolean isGetter(ExecutableElement method) {
        return SourceAnnotationHandler.isNormalGetter(method) || SourceAnnotationHandler.isBooleanGetter(method);
    }

    public static boolean isSetter(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return method.getKind() == ElementKind.METHOD && SourceAnnotationHandler.startsWith(methodName, "set") && method.getParameters().size() == 1 && SourceAnnotationHandler.isVoid(method.getReturnType());
    }

    public static boolean isRootObject(TypeMirror type) {
        return type != null && "java.lang.Object".equals(type.toString());
    }

    public static boolean startsWith(String full, String head) {
        return full != null && head != null && full.startsWith(head) && full.length() > head.length();
    }

    public static boolean equalsByValue(Enum<?> e, Object v) {
        return e == v || v != null && e != null && e.toString().equals(v.toString());
    }

    static {
        mappingAnnos.add(OneToOne.class);
        mappingAnnos.add(OneToMany.class);
        mappingAnnos.add(ManyToOne.class);
        mappingAnnos.add(ManyToMany.class);
        _loc = Localizer.forPackage(SourceAnnotationHandler.class);
    }

    static class AnnotatedFilter
    implements InclusiveFilter<Element> {
        AnnotatedFilter() {
        }

        @Override
        public boolean includes(Element obj) {
            return SourceAnnotationHandler.isAnnotated(obj);
        }
    }

    static class TransientFilter
    implements InclusiveFilter<Element> {
        TransientFilter() {
        }

        @Override
        public boolean includes(Element obj) {
            Set<Modifier> modifiers = obj.getModifiers();
            boolean isTransient = SourceAnnotationHandler.isAnnotatedWith(obj, Transient.class) || modifiers.contains((Object)Modifier.TRANSIENT);
            return !isTransient && !modifiers.contains((Object)Modifier.STATIC);
        }
    }

    static class KindFilter
    implements InclusiveFilter<Element> {
        final ElementKind target;

        public KindFilter(ElementKind target) {
            this.target = target;
        }

        @Override
        public boolean includes(Element obj) {
            return obj.getKind() == this.target;
        }
    }

    static class AccessFilter
    implements InclusiveFilter<Element> {
        final AccessType target;

        public AccessFilter(AccessType target) {
            this.target = target;
        }

        @Override
        public boolean includes(Element obj) {
            Object value = SourceAnnotationHandler.getAnnotationValue(obj, Access.class);
            return SourceAnnotationHandler.equalsByValue(this.target, value);
        }
    }

    static class SetterFilter
    implements InclusiveFilter<ExecutableElement> {
        SetterFilter() {
        }

        @Override
        public boolean includes(ExecutableElement method) {
            return SourceAnnotationHandler.isSetter(method);
        }
    }

    static class GetterFilter
    implements InclusiveFilter<ExecutableElement> {
        GetterFilter() {
        }

        @Override
        public boolean includes(ExecutableElement method) {
            return SourceAnnotationHandler.isGetter(method);
        }
    }

    private static interface InclusiveFilter<T extends Element> {
        public boolean includes(T var1);
    }
}

