/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.form.FormPropertyType;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.task.FormPropertyDef;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.FormPropertyDefCheck;

public class FormPropertyDefValidator
extends AbstractValidator<FormPropertyDefCheck, FormPropertyDef> {
    public boolean isValid(FormPropertyDef formPropertyDef, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (formPropertyDef.getDatePattern() != null && formPropertyDef.getType() != FormPropertyType.Date) {
            context.buildConstraintViolationWithTemplate(FormPropertyDefValidator.getTemplate(EntityViolationType.InvalidFormPropertyDef, "Date pattern found but type not set to Date")).addPropertyNode("datePattern").addConstraintViolation();
            return false;
        }
        if (!formPropertyDef.getEnumValues().isEmpty() && formPropertyDef.getType() != FormPropertyType.Enum) {
            context.buildConstraintViolationWithTemplate(FormPropertyDefValidator.getTemplate(EntityViolationType.InvalidFormPropertyDef, "Enum values found but type not set to Enum")).addPropertyNode("enumValues").addConstraintViolation();
            return false;
        }
        if (formPropertyDef.getEnumValues().isEmpty() && formPropertyDef.getType() == FormPropertyType.Enum) {
            context.buildConstraintViolationWithTemplate(FormPropertyDefValidator.getTemplate(EntityViolationType.InvalidFormPropertyDef, "No enum values provided")).addPropertyNode("enumValues").addConstraintViolation();
            return false;
        }
        return true;
    }
}

