/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.identity.provider;

import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.identity.provider.DefaultIdentityProviderBuilder;
import com.okta.sdk.resource.identity.provider.IdentityProvider;
import com.okta.sdk.resource.identity.provider.IdentityProviderCredentials;
import com.okta.sdk.resource.identity.provider.IdentityProviderCredentialsClient;
import com.okta.sdk.resource.identity.provider.OIDCIdentityProviderBuilder;
import com.okta.sdk.resource.identity.provider.Protocol;
import com.okta.sdk.resource.identity.provider.ProtocolAlgorithmType;
import com.okta.sdk.resource.identity.provider.ProtocolAlgorithmTypeSignature;
import com.okta.sdk.resource.identity.provider.ProtocolAlgorithms;
import com.okta.sdk.resource.identity.provider.ProtocolEndpoint;
import com.okta.sdk.resource.identity.provider.ProtocolEndpoints;
import com.okta.sdk.resource.identity.provider.Provisioning;
import com.okta.sdk.resource.identity.provider.ProvisioningConditions;
import com.okta.sdk.resource.identity.provider.ProvisioningDeprovisionedCondition;
import com.okta.sdk.resource.identity.provider.ProvisioningGroups;
import com.okta.sdk.resource.identity.provider.ProvisioningSuspendedCondition;
import com.okta.sdk.resource.policy.IdentityProviderPolicy;
import com.okta.sdk.resource.policy.PolicyAccountLink;
import com.okta.sdk.resource.policy.PolicySubject;
import com.okta.sdk.resource.policy.PolicySubjectMatchType;
import com.okta.sdk.resource.policy.PolicyUserNameTemplate;

public class OidcIdentityProviderBuilder
extends DefaultIdentityProviderBuilder<OIDCIdentityProviderBuilder>
implements OIDCIdentityProviderBuilder {
    private IdentityProvider.IssuerModeEnum issuerMode;
    private String requestSignatureAlgorithm;
    private ProtocolAlgorithmTypeSignature.ScopeEnum requestSignatureScope;
    private String responseSignatureAlgorithm;
    private ProtocolAlgorithmTypeSignature.ScopeEnum responseSignatureScope;
    private ProtocolEndpoint.BindingEnum acsEndpointBinding;
    private ProtocolEndpoint.TypeEnum acsEndpointType;
    private ProtocolEndpoint.BindingEnum authorizationEndpointBinding;
    private String authorizationEndpointUrl;
    private ProtocolEndpoint.BindingEnum tokenEndpointBinding;
    private String tokenEndpointUrl;
    private ProtocolEndpoint.BindingEnum userInfoEndpointBinding;
    private String userInfoEndpointUrl;
    private ProtocolEndpoint.BindingEnum jwksEndpointBinding;
    private String jwksEndpointUrl;
    private String issuerUrl;
    private String userName;
    private PolicySubjectMatchType matchType;

    public OidcIdentityProviderBuilder setIssuerMode(IdentityProvider.IssuerModeEnum issuerMode) {
        this.issuerMode = issuerMode;
        return this;
    }

    public OidcIdentityProviderBuilder setRequestSignatureAlgorithm(String requestSignatureAlgorithm) {
        this.requestSignatureAlgorithm = requestSignatureAlgorithm;
        return this;
    }

    public OidcIdentityProviderBuilder setRequestSignatureScope(ProtocolAlgorithmTypeSignature.ScopeEnum requestSignatureScope) {
        this.requestSignatureScope = requestSignatureScope;
        return this;
    }

    public OidcIdentityProviderBuilder setResponseSignatureAlgorithm(String responseSignatureAlgorithm) {
        this.responseSignatureAlgorithm = responseSignatureAlgorithm;
        return this;
    }

    public OidcIdentityProviderBuilder setResponseSignatureScope(ProtocolAlgorithmTypeSignature.ScopeEnum responseSignatureScope) {
        this.responseSignatureScope = responseSignatureScope;
        return this;
    }

    public OidcIdentityProviderBuilder setAcsEndpointBinding(ProtocolEndpoint.BindingEnum acsEndpointBinding) {
        this.acsEndpointBinding = acsEndpointBinding;
        return this;
    }

    public OidcIdentityProviderBuilder setAcsEndpointType(ProtocolEndpoint.TypeEnum acsEndpointType) {
        this.acsEndpointType = acsEndpointType;
        return this;
    }

    public OidcIdentityProviderBuilder setAuthorizationEndpointBinding(ProtocolEndpoint.BindingEnum authorizationEndpointBinding) {
        this.authorizationEndpointBinding = authorizationEndpointBinding;
        return this;
    }

    public OidcIdentityProviderBuilder setAuthorizationEndpointUrl(String authorizationEndpointUrl) {
        this.authorizationEndpointUrl = authorizationEndpointUrl;
        return this;
    }

    public OidcIdentityProviderBuilder setTokenEndpointBinding(ProtocolEndpoint.BindingEnum tokenEndpointBinding) {
        this.tokenEndpointBinding = tokenEndpointBinding;
        return this;
    }

    public OidcIdentityProviderBuilder setTokenEndpointUrl(String tokenEndpointUrl) {
        this.tokenEndpointUrl = tokenEndpointUrl;
        return this;
    }

    public OidcIdentityProviderBuilder setUserInfoEndpointBinding(ProtocolEndpoint.BindingEnum userInfoEndpointBinding) {
        this.userInfoEndpointBinding = userInfoEndpointBinding;
        return this;
    }

    public OidcIdentityProviderBuilder setUserInfoEndpointUrl(String userInfoEndpointUrl) {
        this.userInfoEndpointUrl = userInfoEndpointUrl;
        return this;
    }

    public OidcIdentityProviderBuilder setJwksEndpointBinding(ProtocolEndpoint.BindingEnum jwksEndpointBinding) {
        this.jwksEndpointBinding = jwksEndpointBinding;
        return this;
    }

    public OidcIdentityProviderBuilder setJwksEndpointUrl(String jwksEndpointUrl) {
        this.jwksEndpointUrl = jwksEndpointUrl;
        return this;
    }

    public OidcIdentityProviderBuilder setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        return this;
    }

    @Override
    public OidcIdentityProviderBuilder setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Override
    public OidcIdentityProviderBuilder setMatchType(PolicySubjectMatchType matchType) {
        this.matchType = matchType;
        return this;
    }

    @Override
    public IdentityProvider buildAndCreate(Client client) {
        return client.createIdentityProvider(((IdentityProvider)client.instantiate(IdentityProvider.class)).setType("OIDC").setName(this.name).setIssuerMode(this.issuerMode).setProtocol(((Protocol)client.instantiate(Protocol.class)).setAlgorithms(((ProtocolAlgorithms)client.instantiate(ProtocolAlgorithms.class)).setRequest(((ProtocolAlgorithmType)client.instantiate(ProtocolAlgorithmType.class)).setSignature(((ProtocolAlgorithmTypeSignature)client.instantiate(ProtocolAlgorithmTypeSignature.class)).setAlgorithm(this.requestSignatureAlgorithm).setScope(this.requestSignatureScope))).setResponse(((ProtocolAlgorithmType)client.instantiate(ProtocolAlgorithmType.class)).setSignature(((ProtocolAlgorithmTypeSignature)client.instantiate(ProtocolAlgorithmTypeSignature.class)).setAlgorithm(this.responseSignatureAlgorithm).setScope(this.responseSignatureScope)))).setEndpoints(((ProtocolEndpoints)client.instantiate(ProtocolEndpoints.class)).setAcs(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setBinding(this.acsEndpointBinding).setType(this.acsEndpointType)).setAuthorization(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setBinding(this.authorizationEndpointBinding).setUrl(this.authorizationEndpointUrl)).setToken(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setBinding(this.tokenEndpointBinding).setUrl(this.tokenEndpointUrl)).setUserInfo(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setBinding(this.userInfoEndpointBinding).setUrl(this.userInfoEndpointUrl)).setJwks(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setBinding(this.jwksEndpointBinding).setUrl(this.jwksEndpointUrl))).setScopes(this.scopes).setType(Protocol.TypeEnum.OIDC).setCredentials(((IdentityProviderCredentials)client.instantiate(IdentityProviderCredentials.class)).setClient(((IdentityProviderCredentialsClient)client.instantiate(IdentityProviderCredentialsClient.class)).setClientId(this.clientId).setClientSecret(this.clientSecret))).setIssuer(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setUrl(this.issuerUrl))).setPolicy(((IdentityProviderPolicy)client.instantiate(IdentityProviderPolicy.class)).setAccountLink(((PolicyAccountLink)client.instantiate(PolicyAccountLink.class)).setAction(PolicyAccountLink.ActionEnum.AUTO).setFilter(null)).setProvisioning(((Provisioning)client.instantiate(Provisioning.class)).setAction(Provisioning.ActionEnum.AUTO).setConditions(((ProvisioningConditions)client.instantiate(ProvisioningConditions.class)).setDeprovisioned(((ProvisioningDeprovisionedCondition)client.instantiate(ProvisioningDeprovisionedCondition.class)).setAction(ProvisioningDeprovisionedCondition.ActionEnum.NONE)).setSuspended(((ProvisioningSuspendedCondition)client.instantiate(ProvisioningSuspendedCondition.class)).setAction(ProvisioningSuspendedCondition.ActionEnum.NONE))).setGroups(((ProvisioningGroups)client.instantiate(ProvisioningGroups.class)).setAction(ProvisioningGroups.ActionEnum.NONE))).setMaxClockSkew(this.maxClockSkew).setSubject(((PolicySubject)client.instantiate(PolicySubject.class)).setUserNameTemplate(((PolicyUserNameTemplate)client.instantiate(PolicyUserNameTemplate.class)).setTemplate(this.userName)).setMatchType(this.matchType))));
    }
}

