/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class TernaryAggregate
extends Lop {
    public static final String OPCODE_RC = Opcodes.TAKPM.toString();
    public static final String OPCODE_C = Opcodes.TACKPM.toString();
    private Types.Direction _direction;
    private int _numThreads = -1;

    public TernaryAggregate(Lop input1, Lop input2, Lop input3, Types.AggOp aggOp, Types.OpOp2 binOp, Types.Direction direction, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int k) {
        super(Lop.Type.TernaryAggregate, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        this._direction = direction;
        this._numThreads = k;
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation: " + this.getOpCode();
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpCode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input3));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == Types.ExecType.CP || this.getExecType() == Types.ExecType.FED) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
            if (this.getExecType() == Types.ExecType.FED) {
                sb.append("\u00b0");
                sb.append(this._fedOutput.name());
            }
        }
        return sb.toString();
    }

    private String getOpCode() {
        switch (this._direction) {
            case RowCol: {
                return OPCODE_RC;
            }
            case Col: {
                return OPCODE_C;
            }
        }
        throw new RuntimeException("Unsupported aggregation direction: " + this._direction);
    }
}

