/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.job;

import jakarta.validation.ValidationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.bval.jsr.ApacheFactoryContext;
import org.apache.bval.jsr.job.ValidateBean;
import org.apache.bval.jsr.job.ValidateParameters;
import org.apache.bval.jsr.job.ValidateProperty;
import org.apache.bval.jsr.job.ValidateReturnValue;
import org.apache.bval.util.Validate;

public class ValidationJobFactory {
    private final ApacheFactoryContext validatorContext;

    public ValidationJobFactory(ApacheFactoryContext validatorContext) {
        this.validatorContext = Validate.notNull(validatorContext, "validatorContext", new Object[0]);
    }

    public <T> ValidateBean<T> validateBean(T bean, Class<?> ... groups) {
        return new ValidateBean<T>(this.validatorContext, bean, groups);
    }

    public <T> ValidateProperty<T> validateProperty(T bean, String property, Class<?> ... groups) {
        try {
            ValidateProperty<T> result = new ValidateProperty<T>(this.validatorContext, bean, property, groups);
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
    }

    public <T> ValidateProperty<T> validateValue(Class<T> rootBeanClass, String property, Object value, Class<?> ... groups) {
        ValidateProperty<T> result = new ValidateProperty<T>(this.validatorContext, rootBeanClass, property, value, groups);
        return result;
    }

    public <T> ValidateParameters.ForMethod<T> validateParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        return new ValidateParameters.ForMethod<T>(this.validatorContext, object, method, parameterValues, groups);
    }

    public <T> ValidateReturnValue.ForMethod<T> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        return new ValidateReturnValue.ForMethod<T>(this.validatorContext, object, method, returnValue, groups);
    }

    public <T> ValidateParameters.ForConstructor<T> validateConstructorParameters(Constructor<? extends T> constructor, Object[] parameterValues, Class<?> ... groups) {
        return new ValidateParameters.ForConstructor<T>(this.validatorContext, constructor, parameterValues, groups);
    }

    public <T> ValidateReturnValue.ForConstructor<T> validateConstructorReturnValue(Constructor<? extends T> constructor, T createdObject, Class<?> ... groups) {
        return new ValidateReturnValue.ForConstructor<T>(this.validatorContext, constructor, createdObject, groups);
    }
}

