/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Primitives {
    private static final Map<Class, Class> PRIMITIVE_TO_WRAPPER;
    private static final Map<Class, Class> WRAPPER_TO_PRIMITIVE;

    public static Class<?> findSibling(Class<?> wrapperOrPrimitive) {
        Class aClass = PRIMITIVE_TO_WRAPPER.get(wrapperOrPrimitive);
        return aClass != null ? aClass : WRAPPER_TO_PRIMITIVE.get(wrapperOrPrimitive);
    }

    public static Class<?> toWrapper(Class<?> primitive) {
        return PRIMITIVE_TO_WRAPPER.get(primitive);
    }

    public static Class<?> toPrimitive(Class<?> wrapper) {
        return WRAPPER_TO_PRIMITIVE.get(wrapper);
    }

    private Primitives() {
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class<Comparable<Boolean>>> map = new HashMap<Class<Comparable<Boolean>>, Class<Comparable<Boolean>>>();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Character.TYPE, Character.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(Boolean.class, Boolean.TYPE);
        map.put(Character.class, Character.TYPE);
        map.put(Byte.class, Byte.TYPE);
        map.put(Short.class, Short.TYPE);
        map.put(Integer.class, Integer.TYPE);
        map.put(Long.class, Long.TYPE);
        map.put(Float.class, Float.TYPE);
        map.put(Double.class, Double.TYPE);
        WRAPPER_TO_PRIMITIVE = Collections.unmodifiableMap(map);
    }
}

