/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.text;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class Text
implements Comparable<Text>,
ToXContentFragment {
    public static final Text[] EMPTY_ARRAY = new Text[0];
    private BytesReference bytes;
    private String text;
    private int hash;

    public static Text[] convertFromStringArray(String[] strings) {
        if (strings.length == 0) {
            return EMPTY_ARRAY;
        }
        Text[] texts = new Text[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            texts[i] = new Text(strings[i]);
        }
        return texts;
    }

    public Text(BytesReference bytes) {
        this.bytes = bytes;
    }

    public Text(String text) {
        this.text = text;
    }

    public boolean hasBytes() {
        return this.bytes != null;
    }

    public BytesReference bytes() {
        if (this.bytes == null) {
            this.bytes = new BytesArray(this.text.getBytes(StandardCharsets.UTF_8));
        }
        return this.bytes;
    }

    public boolean hasString() {
        return this.text != null;
    }

    public String string() {
        return this.text == null ? this.bytes.utf8ToString() : this.text;
    }

    public String toString() {
        return this.string();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.bytes().hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.bytes().equals(((Text)obj).bytes());
    }

    @Override
    public int compareTo(Text text) {
        return this.bytes().compareTo(text.bytes());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.hasString()) {
            return builder.value(this.string());
        }
        BytesRef br = this.bytes().toBytesRef();
        return builder.utf8Value(br.bytes, br.offset, br.length);
    }
}

