/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.NonResettingRestartException;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.IWritableRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.flow.ResetResponseException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;

public class RestartResponseAtInterceptPageException
extends ResetResponseException {
    private static final long serialVersionUID = 1L;
    static IRequestMapper MAPPER = new IRequestMapper(){

        @Override
        public int getCompatibilityScore(Request request) {
            return this.matchedData(request) != null ? Integer.MAX_VALUE : 0;
        }

        @Override
        public Url mapHandler(IRequestHandler requestHandler) {
            return null;
        }

        @Override
        public IRequestHandler mapRequest(Request request) {
            InterceptData data = this.matchedData(request);
            if (data != null) {
                if (!data.postParameters.isEmpty() && request.getPostParameters() instanceof IWritableRequestParameters) {
                    IWritableRequestParameters parameters = (IWritableRequestParameters)request.getPostParameters();
                    parameters.reset();
                    for (String s : data.postParameters.keySet()) {
                        parameters.setParameterValues(s, data.postParameters.get(s));
                    }
                }
                InterceptData.clear();
            }
            return null;
        }

        private InterceptData matchedData(Request request) {
            InterceptData data = InterceptData.get();
            if (data != null && data.originalUrl.equals(request.getOriginalUrl())) {
                return data;
            }
            return null;
        }
    };

    public RestartResponseAtInterceptPageException(Page interceptPage) {
        super(new RenderPageRequestHandler(new PageProvider(interceptPage), RenderPageRequestHandler.RedirectPolicy.AUTO_REDIRECT));
        InterceptData.set();
    }

    public RestartResponseAtInterceptPageException(Class<? extends Page> interceptPageClass) {
        this(interceptPageClass, null);
    }

    public RestartResponseAtInterceptPageException(Class<? extends Page> interceptPageClass, PageParameters parameters) {
        super(new RenderPageRequestHandler(new PageProvider(interceptPageClass, parameters), RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT));
        InterceptData.set();
    }

    public static Url getOriginalUrl() {
        Url originalUrl = null;
        InterceptData data = InterceptData.get();
        if (data != null) {
            originalUrl = data.getOriginalUrl();
        }
        return originalUrl;
    }

    public static Map<String, List<StringValue>> getOriginalPostParameters() {
        Map<String, List<StringValue>> postParameters = null;
        InterceptData data = InterceptData.get();
        if (data != null) {
            postParameters = data.getPostParameters();
        }
        return postParameters;
    }

    static void continueToOriginalDestination() {
        InterceptData data = InterceptData.get();
        if (data != null) {
            String url = RequestCycle.get().getUrlRenderer().renderUrl(data.originalUrl);
            throw new NonResettingRestartException(url);
        }
    }

    static void clearOriginalDestination() {
        InterceptData.clear();
    }

    static class InterceptData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Url originalUrl;
        private Map<String, List<StringValue>> postParameters;
        private static final MetaDataKey<InterceptData> key = new MetaDataKey<InterceptData>(){
            private static final long serialVersionUID = 1L;
        };

        InterceptData() {
        }

        public Url getOriginalUrl() {
            return this.originalUrl;
        }

        public Map<String, List<StringValue>> getPostParameters() {
            return this.postParameters;
        }

        public static void set() {
            Session session = Session.get();
            session.bind();
            InterceptData data = new InterceptData();
            Request request = RequestCycle.get().getRequest();
            data.originalUrl = request.getOriginalUrl();
            Iterator<Url.QueryParameter> itor = data.originalUrl.getQueryParameters().iterator();
            while (itor.hasNext()) {
                Url.QueryParameter parameter = itor.next();
                String parameterName = parameter.getName();
                if (!"wicket-ajax".equals(parameterName) && !"wicket-ajax-baseurl".equals(parameterName) && !"_".equals(parameterName)) continue;
                itor.remove();
            }
            data.postParameters = new HashMap<String, List<StringValue>>();
            for (String s : request.getPostParameters().getParameterNames()) {
                if ("wicket-ajax".equals(s) || "wicket-ajax-baseurl".equals(s) || "_".equals(s)) continue;
                data.postParameters.put(s, new ArrayList<StringValue>(request.getPostParameters().getParameterValues(s)));
            }
            session.setMetaData(key, data);
        }

        public static InterceptData get() {
            if (Session.exists()) {
                return (InterceptData)Session.get().getMetaData((MetaDataKey)key);
            }
            return null;
        }

        public static void clear() {
            if (Session.exists()) {
                Session.get().setMetaData(key, null);
            }
        }
    }
}

