/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.util.FileItemHeadersImpl;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

class ServletPartFileItem
implements FileItem {
    private final Part part;
    private final boolean isFormField;

    ServletPartFileItem(Part part) {
        Args.notNull(part, "part");
        this.part = part;
        String contentType = part.getContentType();
        this.isFormField = contentType == null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.part.getInputStream();
    }

    @Override
    public String getContentType() {
        return this.part.getContentType();
    }

    @Override
    public String getName() {
        return this.getFileName(this.part);
    }

    private String getFileName(Part part) {
        String contentDisposition = part.getHeader("content-disposition");
        for (String cd : Strings.split(contentDisposition, ';')) {
            if (!cd.trim().startsWith("filename")) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return null;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public long getSize() {
        return this.part.getSize();
    }

    @Override
    public byte[] get() {
        try {
            return IOUtils.toByteArray(this.getInputStream());
        }
        catch (IOException iox) {
            throw new WicketRuntimeException("Could not read upload's part input stream", iox);
        }
    }

    @Override
    public String getString(String encoding) throws UnsupportedEncodingException {
        byte[] bytes = this.get();
        return new String(bytes, encoding);
    }

    @Override
    public String getString() {
        try {
            return this.getString("UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            throw new WicketRuntimeException("UTF-8 must be supported", uex);
        }
    }

    @Override
    public void write(File file) throws Exception {
        this.part.write(file.getName());
    }

    @Override
    public void delete() {
        try {
            this.part.delete();
        }
        catch (IOException iox) {
            throw new WicketRuntimeException("A problem occurred while deleting an upload part", iox);
        }
    }

    @Override
    public String getFieldName() {
        return this.part.getName();
    }

    @Override
    public void setFieldName(String name) {
        throw new UnsupportedOperationException("setFieldName");
    }

    @Override
    public boolean isFormField() {
        return this.isFormField;
    }

    @Override
    public void setFormField(boolean state) {
        throw new UnsupportedOperationException("setFormField");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("getOutputStream");
    }

    @Override
    public FileItemHeaders getHeaders() {
        FileItemHeadersImpl fileItemHeaders = new FileItemHeadersImpl();
        for (String headerName : this.part.getHeaderNames()) {
            Collection<String> headerValues = this.part.getHeaders(headerName);
            for (String headerValue : headerValues) {
                fileItemHeaders.addHeader(headerName, headerValue);
            }
        }
        return fileItemHeaders;
    }

    @Override
    public void setHeaders(FileItemHeaders headers) {
        throw new UnsupportedOperationException("setHeaders");
    }
}

